ORCA/M Asm65816 2.1.0

0001 000C                       TITLE 'Basic Support'
0002 000C
0003 000C              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 000C              ;	by EdAsmCvtIIGS version 1.2d7 on 5/14/91 at 11:36:32 PM
0005 000C
0006 000C              *
0007 000C              *
0008 000C              BASIC    EQU   *
0009 000C 5A                    PHY   
0010 000D 48                    PHA   
0011 000E 8E F8 07              STX   |mslot
0012 0011 20 3C 07              JSR   SetBasicMode
0013 0014              *
0014 0014              * Maintain the defaults flag.  This is trashed whenever anyone resets
0015 0014              *  the system or when a user changes a port characteristic in the 
0016 0014              *  control panel.  We reset it whenever a non-C100 entry is made to us
0017 0014              *  to guarantee that subsequent C100s will do a default.
0018 0014              *
0019 0014 BF 82 00 E1           LDA   >C1Flag,x
0020 0018 08                    PHP                            ;V is C100, Z is reset flag
0021 0019              *
0022 0019 A9 FF                 LDA   #$FF
0023 001B 70 01                 BVS   msup                     ;Take if we came through CN00
0024 001D 1A                    INC   a
0025 001E              MSUP     EQU   *
0026 001E 9F 82 00 E1           STA   >C1Flag,x                ;If CN00, store $FF; $00 otherwise
0027 0022              *
0028 0022              * Now decide whether to initialize (default) the port.  Only do so if
0029 0022              *  we came through $CN00 and the CFlag was = $00.
0030 0022              *
0031 0022 28                    PLP                            ;Get back V,Z
0032 0023 50 1C                 BVC   sudone                   ;Skip if CN05 or CN07 entry
0033 0025 D0 03                 BNE   sunodef                  ;Skip if CFlag was non zero
0034 0027              *
0035 0027 20 2A 0C     SUDODEF  JSR   default                  ;Set up defaults 
0036 002A              *
0037 002A              * If either hook is partially present, make sure the low part is correct
0038 002A              *
0039 002A              SUNODEF  EQU   *
0040 002A E4 37                 CPX   cswh
0041 002C D0 0B                 BNE   fromin                   ;Maybe it's an IN#...
0042 002E A9 07                 LDA   #7
0043 0030 C5 36                 CMP   cswl                     ;Is low part already set?
0044 0032 F0 05                 BEQ   fromin                   ;If so, no need to set it
0045 0034 85 36                 STA   cswl
0046 0036              FROMOUT  EQU   *
0047 0036 18                    CLC                            ;We fixed the hook so it
0048 0037 80 08                 BRA   sudone                   ;Must have been a PR#
0049 0039              FROMIN   EQU   *
0050 0039 E4 39                 CPX   kswh                     ;Is the input hook half there?
0051 003B D0 F9                 BNE   fromout                  ;Wasn't an IN#...assume PR#
0052 003D A9 05                 LDA   #5                       ;Fill in the other half of hook
0053 003F 85 38                 STA   kswl
0054 0041              *
0055 0041              SUDONE   EQU   *
0056 0041 B0 03                 BCS   commport                 ;If input, branch
0057 0043 4C C2 00              JMP   serport
0058 0046              *
0059 0046              COMMPORT EQU   *
0060 0046 68                    PLA                            ;Get the char
0061 0047 2C 1F C0              BIT   |RD80VID
0062 004A 30 04                 BMI   omg
0063 004C A4 24                 LDY   ch
0064 004E 91 28                 STA   (basl),y                 ;Store what was beneath the cursor
0065 0050              *
0066 0050              OMG      EQU   *
0067 0050 EB                    XBA                            ;On hold for a momentito
0068 0051 AD 15 C0              LDA   |RDCXROM
0069 0054 48                    PHA   
0070 0055 8D 07 C0              STA   |SETINTCXROM
0071 0058 EB                    XBA                            ;Get back the character
0072 0059              *
0073 0059 80 2D                 BRA   term1                    ;Input 
0074 005B 3C B8 04     NOESC    BIT   |sermode,x               ;In terminal mode?
0075 005E 50 1C                 BVC   exit1                    ;If not, return key
0076 0060 20 EB 01              JSR   serout2                  ;Out it goes
0077 0063 80 23                 BRA   term1
0078 0065              TESTKBD  EQU   *
0079 0065 68                    PLA                            ;Get current char
0080 0066 20 FC CE              JSR   |UPDATE                  ;Update cursor & check keyboard
0081 0069 10 20                 BPL   serin                    ;N=0 if no new key
0082 006B 20 7D 03              JSR   command                  ;Test for command
0083 006E B0 EB                 BCS   noesc                    ;Branch if not
0084 0070 29 5F                 AND   #$5f                     ;upshift for following tests
0085 0072 C9 51                 CMP   #'Q'                     ;Quit?
0086 0074 F0 04                 BEQ   exitX
0087 0076 C9 52                 CMP   #'R'                     ;Reset?
0088 0078 D0 0E                 BNE   term1                    ;Go check serial 
0089 007A A9 98        EXITX    LDA   #$98                     ;return a CTRL-X
0090 007C 7A           EXIT1    PLY   
0091 007D              *
0092 007D 30 03                 BMI   exit2
0093 007F 8D 06 C0              STA   |SETSLOTCXROM
0094 0082              EXIT2    EQU   *
0095 0082 7A                    PLY   
0096 0083 6B                    RTL   
0097 0084              *
0098 0084 18           GOREMOTE CLC                            ;Into remote mode
0099 0085 20 1D 06     GOTERM   JSR   setterm                  ;Into terminal mode 
0100 0088              TERM1    EQU   *
0101 0088 20 C9 CE              JSR   |SHOWCUR                 ;Get current char on screen
0102 008B 48           SERIN    PHA   
0103 008C 20 E6 02     SINOKBD  JSR   xrdser                   ;Is it ready?
0104 008F B0 09                 BCS   sidata                   ;Branch if we got data
0105 0091 BD 38 07              LDA   |flags,x                 ;Is keyboard enabled?
0106 0094 29 10                 AND   #$10
0107 0096 F0 CD                 BEQ   testkbd                  ;Branch if enabled
0108 0098 80 F2                 BRA   sinokbd                  ;Go test acia again
0109 009A A8           SIDATA   TAY                            ;Save new input in y for now 
0110 009B 68                    PLA   
0111 009C 5A                    PHY                            ;Save new char on stack
0112 009D 20 E7 CD              JSR   |STORCH                  ;Fix the screen
0113 00A0 68                    PLA                            ;Get the new data
0114 00A1 BC 38 04              LDY   |eschar,x                ;If 0, don't modify char
0115 00A4 F0 12                 BEQ   sinomod
0116 00A6 09 80                 ORA   #$80                     ;Apple loves the high bit
0117 00A8 C9 91                 CMP   #xon
0118 00AA F0 DC                 BEQ   term1                    ;Ignore ^Q
0119 00AC C9 FF                 CMP   #$FF                     ;Ignore FFs
0120 00AE F0 D8                 BEQ   term1
0121 00B0 C9 92                 CMP   #$92                     ;^R for remote?
0122 00B2 F0 D0                 BEQ   goremote
0123 00B4 C9 94                 CMP   #$94                     ;^T for terminal mode?
0124 00B6 F0 CD                 BEQ   goterm
0125 00B8 3C B8 04     SINOMOD  BIT   |sermode,x               ;In terminal mode?
0126 00BB 50 BF                 BVC   exit1                    ;Return to user if not A = char 
0127 00BD 20 94 F8              JSR   |COUT                    ;Onto the screen with it
0128 00C0 80 C6                 BRA   term1
0129 00C2              *
0130 00C2              * Come back here if this is a printer port
0131 00C2              *
0132 00C2              * Integer and older versions of Applesoft Basic did tabbing by jamming
0133 00C2              *  CH to the column position where they wished to be.  This works fine
0134 00C2              *  with video but presents a problem for us.  To convince Basic not to
0135 00C2              *  to issue a carriage return after 40 or 80 columns when printing, the
0136 00C2              *  serial firmware jams CH to zero.  We then take the responsibility for
0137 00C2              *  watching our own column counter, and when we detect that we are near
0138 00C2              *  our line length, we set CH to a value which Basic will interpret as
0139 00C2              *  being near the end of the line; then Basic will do its end of line
0140 00C2              *  chores.
0141 00C2              *
0142 00C2              *  Tabbing in this environment starts by looking at CH.  If CH is zero 
0143 00C2              *  then there's no tabbing.  If CH is 8 or 16, then we assume that it
0144 00C2              *  is Integer or Applesoft Basic attempting to do a tab, and we update
0145 00C2              *  CH to the next tab stop (just as Basic would have if we weren't
0146 00C2              *  confusing it by setting CH to zero every time).  If CH is a value
0147 00C2              *  other than 8 or 16 we assume that this is an absolute position
0148 00C2              *  that someone wishes to tab to, and we keep outputting spaces until
0149 00C2              *  our column counter = CH.
0150 00C2              *
0151 00C2              *  CAVEAT:  When Applesoft was revved to work better with 80 column
0152 00C2              *  video, the tabbing code (both comma tabs and explicit TAB()s) was
0153 00C2              *  altered so that CH was no longer jammed- instead Applesoft tries
0154 00C2              *  to figure out the number of spaces to output itself to move to the
0155 00C2              *  desired location.  Much cleaner, yes, but it bases its space
0156 00C2              *  calculation on CH, the location that the printer firmware jams to
0157 00C2              *  zero every character!  Ooops.  Basic never knows where it really
0158 00C2              *  is and as a result, every comma results in exactly 16 spaces
0159 00C2              *  regardless of tab position, and every TAB(n) just gives you n
0160 00C2              *  spaces.  The Super Serial Card has a command 'TE' which defeats
0161 00C2              *  the CH zero jam, and using this command makes new Applesoft tabbing
0162 00C2              *  work okay (the //c can't be helped since it does not have this
0163 00C2              *  command).  The Cortland has this command and it must be issued
0164 00C2              *  to make Applesoft tabbing work correctly. (The Cortland command
0165 00C2              *  is 'A E/D' which stands for Applesoft.)
0166 00C2              *
0167 00C2              *  Amen.
0168 00C2              *
0169 00C2              SERPORT  EQU   *
0170 00C2 BD 38 07              LDA   |flags,x
0171 00C5 0A                    ASL   A                        ;A = flags 
0172 00C6 7A                    PLY                            ;Get char
0173 00C7 5A                    PHY   
0174 00C8              *
0175 00C8              * If we are in Zap mode, we want to avoid tabbing, or carriage return
0176 00C8              *  stuffing, and have exactly what goes in come out and no more.
0177 00C8              *
0178 00C8 BD 38 05              LDA   |sermode3,x
0179 00CB 89 80                 BIT   #CSDMask
0180 00CD D0 61                 BNE   prnow
0181 00CF              *
0182 00CF              * PWIDTH set to zero means 'unlimited line length'.  Therefore any
0183 00CF              *  comparison to the current column position must special case PWDTH=0.
0184 00CF              *  In this case, we simulate CH-PWDTH < 0.
0185 00CF              *
0186 00CF BD 38 06              LDA   |pwdth,x
0187 00D2 08                    PHP                            ;Save Z
0188 00D3 A5 24                 LDA   ch
0189 00D5 28                    PLP                            ;Pull back Z and C
0190 00D6              *
0191 00D6 B0 23                 BCS   servid                   ;Branch if video echo 
0192 00D8 F0 08                 BEQ   chok
0193 00DA DD 38 06              CMP   |pwdth,x                 ;If CH >= PWIDTH, then CH = COL
0194 00DD 90 03                 BCC   chok
0195 00DF BD B8 06              LDA   |col,x
0196 00E2              *
0197 00E2 DD B8 06     CHOK     CMP   |col,x                   ;Must be >  for valid tab
0198 00E5 B0 10                 BCS   fixch                    ;Branch if ok
0199 00E7              *
0200 00E7 C9 08                 CMP   #8                       ;Is it Integer Basic trying to tab?
0201 00E9 F0 04                 BEQ   chok1                    ;Yup, line up to a tab stop
0202 00EB C9 10                 CMP   #16                      ;Is it Applesoft trying to tab?
0203 00ED D0 12                 BNE   prnt                     ;Nope, no 'CH stuff' style basic tabbing
0204 00EF              *
0205 00EF              * Now set CH to the next highest tab stop for Applesoft & Integer Basic
0206 00EF              *
0207 00EF              CHOK1    EQU   *
0208 00EF 09 F0                 ORA   #$F0                     ;Create $F0 or $F8 to find tab stop
0209 00F1 3D B8 06              AND   |col,x                   ;Find previous tab stop  
0210 00F4 18                    CLC   
0211 00F5 65 24                 ADC   ch                       ;Add the tab increment 
0212 00F7 85 24        FIXCH    STA   ch                       ;Save the new position
0213 00F9 80 06                 BRA   prnt
0214 00FB              *
0215 00FB C5 21        SERVID   CMP   wndwdth                  ;If ch>= wndwdth go back to start of line
0216 00FD 90 02                 BLT   prnt
0217 00FF 64 24                 STZ   ch                       ;Go back to left edge 
0218 0101              *
0219 0101              * Do CR stuffing if this was asked for.
0220 0101              * There are two conditions under which we do not generate CRs.  One
0221 0101              *  is the case where the line width is zero, the other is the case when
0222 0101              *  the CR stuff bit is clear.  Check for both cases.
0223 0101              *
0224 0101              PRNT     EQU   *
0225 0101 BD B8 05              LDA   |sermode2,x
0226 0104 89 08                 BIT   #crstuffmask
0227 0106 F0 15                 BEQ   prnt2                    ;Skip out if bit off
0228 0108              *
0229 0108 BD 38 06              LDA   |pwdth,x
0230 010B F0 10                 BEQ   prnt2                    ;2nd condition
0231 010D              *
0232 010D BD B8 06              LDA   |col,x
0233 0110 DD 38 06              CMP   |pwdth,x
0234 0113 90 08                 BLT   prnt2                    ;If col<pwdth forget it...
0235 0115              *
0236 0115 A9 1A                 LDA   #$1A                     ;CR*2
0237 0117 C0 80                 CPY   #$80                     ;Set carry if hi bit of chartoprnt=1
0238 0119 6A                    ROR   a                        ;Shift into out CR
0239 011A 20 04 02              JSR   goser3                   ;Print without echoing
0240 011D              *
0241 011D              * See if we need to do any tabbing.  If CH is bigger than our column
0242 011D              *  counter, then someone changed CH, and we compensate by printing
0243 011D              *  blanks until their CH is equal to our COL.
0244 011D              *
0245 011D              PRNT2    EQU   *
0246 011D 7A                    PLY   
0247 011E 5A                    PHY   
0248 011F BD B8 06              LDA   |col,x
0249 0122 C5 24                 CMP   ch
0250 0124 B0 0A                 BGE   prnow                    ;If COL>=CH no tabbing required
0251 0126              *
0252 0126 A9 40                 LDA   #$40                     ;Blank*2
0253 0128 C0 80                 CPY   #$80                     ;Set C to high bit of char to print
0254 012A 6A                    ROR   a
0255 012B 20 04 02              JSR   goser3                   ;Output without echoing
0256 012E 80 D1                 BRA   prnt                     ;See if that fixed it
0257 0130              *
0258 0130 98           PRNOW    TYA   
0259 0131 20 E6 01              JSR   serout                   ;Print the actual char
0260 0134              *
0261 0134 3C 38 07              BIT   |flags,x                 ;In video all this is done for us
0262 0137 30 29                 BMI   done
0263 0139              *
0264 0139 BD 38 06              LDA   |pwdth,x                 ;Unlimited line length?
0265 013C F0 10                 BEQ   setch                    ;Yes- never fool Basic into endoflining
0266 013E              *
0267 013E              * In order to have BASIC tabbing to work correctly, window should
0268 013E              * be set to the same length as the column width used for printing.
0269 013E              * This must be done from the BASIC program and cannot be done in this
0270 013E              * rom space.
0271 013E              *
0272 013E 38                    SEC   
0273 013F BD B8 06              LDA   |col,x                   ;Check if within 8 chars of right edge
0274 0142 FD 38 06              SBC   |pwdth,x                 ;So BASIC can format output 
0275 0145 C9 F8                 CMP   #$F8
0276 0147 90 05                 BCC   setch                    ;If not within 8, we're done
0277 0149 18                    CLC   
0278 014A 65 21                 ADC   wndwdth
0279 014C 80 0A                 BRA   kl1                      ;Skip the load
0280 014E              *
0281 014E              * Normally, we always jam CH to zero to make printing with
0282 014E              *  large line lengths work.  Unfortunately it screws up Applesoft
0283 014E              *  tabbing, so if the tabbing bit is set, we set CH not to zero but
0284 014E              *  to our real column count.  Then Applesoft tabs wonderfully, and
0285 014E              *  output is limited to 40 or 80 columns depending on the video mode.
0286 014E              *
0287 014E              SETCH    EQU   *
0288 014E BD 38 05              LDA   |sermode3,x
0289 0151 29 08                 AND   #BTabMask
0290 0153 F0 03                 BEQ   kl1
0291 0155 BD B8 06              LDA   |col,x
0292 0158              KL1      EQU   *
0293 0158 85 24                 STA   ch
0294 015A              *
0295 015A              * If 80 cols is active, BASIC depends on OURCH ($57B) to be updated
0296 015A              *  to do tabbing right (instead of CH ($24) ).  Slam it if RD80VID
0297 015A              *  is active.
0298 015A              *
0299 015A 2C 1F C0              BIT   |RD80VID
0300 015D 10 03                 BPL   done
0301 015F 8D 7B 05              STA   |OURCH
0302 0162              *
0303 0162              DONE     EQU   *
0304 0162 68                    PLA                            ;Restore regs
0305 0163 7A                    PLY   
0306 0164 6B           SERRTS   RTL   
0307 0165              *
0308 0165              *
0309 0165                       TITLE 'Pascal Support'
0310 0165              *
0311 0165              *
0312 0165              PASCAL   EQU   *
0313 0165              *
0314 0165              * On entry, Y has nx, where x=4 (Init), 3 (Read), 2 (Write),
0315 0165              *  or 1 (Status), and n is the slot (1 or 2).  Make sure that
0316 0165              *  Y has x stripped off on return, and use x to determine which
0317 0165              *  routine we should vector to.
0318 0165              *
0319 0165 20 40 07              JSR   SetPascalMode
0320 0168 8E F8 07              STX   |MSlot                   ;Save away the port index
0321 016B EB                    XBA                            ;Keep A
0322 016C 98                    TYA                            ;Get nx
0323 016D 48                    PHA                            ;Keep nx around
0324 016E 29 F0                 AND   #%11110000               ;Discard the x part
0325 0170 A8                    TAY                            ;This will get returned later
0326 0171 68                    PLA                            ;Pull back cx
0327 0172 29 07                 AND   #%00000111               ;Discard the c part
0328 0174 5A                    PHY                            ;Keep to return to caller
0329 0175 EB                    XBA                            ;Get back the original A reg
0330 0176 48                    PHA                            ;Push that, too
0331 0177 EB                    XBA                            ;Get back the call type
0332 0178              *
0333 0178 3A                    DEC   a
0334 0179 D0 3F                 BNE   notstatus
0335 017B              *
0336 017B              * This is the status routine.  When buffering is not on, a check is
0337 017B              *  made by calling HardCheck if it is an Tx inquiry, or GetStat
0338 017B              *  if it is an Rx inquiry.  If buffering is on, check the queues.
0339 017B              *
0340 017B 68                    PLA                            ;Get the inquiry type (0 or 1)
0341 017C 48                    PHA                            ;Return to the user
0342 017D 4A                    LSR   a                        ;C has 0 (Tx) or 1 (Rx)
0343 017E D0 60                 BNE   perr                     ;Illegal status code
0344 0180              *
0345 0180              * Find out if we're buffering or not
0346 0180              *
0347 0180 BD B8 05              LDA   |sermode2,x
0348 0183 89 40                 BIT   #BfrngMask
0349 0185 F0 16                 BEQ   ps0
0350 0187              *
0351 0187              * We're buffering.  If read inquiry, check length; if write, space left.
0352 0187              *
0353 0187 8B                    PHB   
0354 0188 B0 06                 BCS   psb1                     ;Make rcv buffer check
0355 018A 38                    SEC                            ;Tx buffer check
0356 018B 20 B3 0B              JSR   QSpace
0357 018E 80 04                 BRA   psb2
0358 0190              *
0359 0190              PSB1     EQU   *
0360 0190 18                    CLC                            ;Rcv inquiry
0361 0191 20 9D 0B              JSR   QLength
0362 0194              PSB2     EQU   *
0363 0194 E2 30                 SEP   #%00110000
0364 0196 38                    SEC   
0365 0197 D0 01                 BNE   psb3
0366 0199 18                    CLC   
0367 019A              PSB3     EQU   *
0368 019A AB                    PLB                            ;Return DBR to 0
0369 019B 80 31                 BRA   pread2
0370 019D              *
0371 019D              * Non buffered case
0372 019D              *
0373 019D              PS0      EQU   *
0374 019D B0 0C                 BCS   pstat1                   ;This is a Rx inquiry
0375 019F              *
0376 019F              * Return with the carry clear (not ready) if we're awaiting XON
0377 019F              *
0378 019F BD 38 07              LDA   |flags,x
0379 01A2 89 02                 BIT   #WaitXMask
0380 01A4 D0 28                 BNE   pread2                   ;If awaiting XON, we're not ready
0381 01A6              *
0382 01A6 20 B2 02              JSR   HardCheck                ;Check output status
0383 01A9 80 23                 BRA   pread2                   ;Carry is set if char avail
0384 01AB              PSTAT1   EQU   *
0385 01AB              *
0386 01AB              * If the one byte buffer is full, there is a character available
0387 01AB              *
0388 01AB 89 10                 BIT   #ChrBufMask              ;Sermode2 already in accumulator
0389 01AD D0 1F                 BNE   pread2                   ;Carry already set
0390 01AF 20 7C C1              JSR   GetStat                  ;Check Rx buffer
0391 01B2              *
0392 01B2 4A                    LSR   a                        ;Move Rx char ready to carry
0393 01B3 90 19                 BCC   pread2                   ;If no char, don't check for error
0394 01B5              *
0395 01B5              * Check if the character had an error, or if we're doing XON/XOFF
0396 01B5              *  whether the next character is XON or XOFF... etc.    
0397 01B5              *
0398 01B5 20 DC 0D              JSR   Potpourri                ;Carry set means a char is available
0399 01B8 80 14                 BRA   pread2
0400 01BA              *
0401 01BA              NOTSTATUS EQU   *
0402 01BA 3A                    DEC   a
0403 01BB D0 07                 BNE   notwrite
0404 01BD              *
0405 01BD              * This is the Write routine
0406 01BD              *
0407 01BD 68                    PLA   
0408 01BE 48                    PHA                            ;Got back original char
0409 01BF 20 E6 01              JSR   serout
0410 01C2 80 0A                 BRA   pread2
0411 01C4              *
0412 01C4              NOTWRITE EQU   *
0413 01C4 3A                    DEC   a
0414 01C5 D0 0C                 BNE   notread
0415 01C7              *
0416 01C7              * This is the Read routine. Wait until we have a character from SCC.
0417 01C7              *
0418 01C7 68                    PLA                            ;Make room for return of char
0419 01C8              PWAIT    EQU   *
0420 01C8 20 E6 02              JSR   xrdser
0421 01CB 90 FB                 BCC   pwait
0422 01CD 48                    PHA   
0423 01CE              PREAD2   EQU   *
0424 01CE 68                    PLA   
0425 01CF 7A                    PLY   
0426 01D0 A2 00                 LDX   #0
0427 01D2 6B                    RTL   
0428 01D3              *
0429 01D3              NOTREAD  EQU   *
0430 01D3              *
0431 01D3              * It must be the Init routine.  Make sure that we turn off the
0432 01D3              *  generation of line feeds since Pascal throws them out there.
0433 01D3              *  Also turn off basic formatting (tabbing).
0434 01D3              *
0435 01D3 20 2A 0C              JSR   default
0436 01D6 BD 38 07              LDA   |flags,x
0437 01D9 29 BF                 AND   #GenLFMask--$FF
0438 01DB 9D 38 07              STA   |flags,x
0439 01DE 80 EE                 BRA   pread2
0440 01E0              *
0441 01E0              PERR     EQU   *
0442 01E0 A2 40                 LDX   #$40
0443 01E2 68                    PLA   
0444 01E3 7A                    PLY   
0445 01E4 18                    CLC   
0446 01E5 6B                    RTL   
0447 01E6              *
0448 01E6              *
0449 01E6                       TITLE 'Serial Output Routines'
0450 01E6              SEROUT   EQU   *                        ;Serial output
0451 01E6              *
0452 01E6              * See if this character is part of a command string
0453 01E6              *
0454 01E6 20 7D 03              JSR   command                  ;Check if command
0455 01E9 90 4F                 BCC   serdone                  ;All done if it is
0456 01EB              *
0457 01EB              * See if echo is on... don't echo XON character
0458 01EB              *
0459 01EB              SEROUT2  EQU   *
0460 01EB 3C 38 07              BIT   |flags,x                 ;N=1 iff video on
0461 01EE 10 14                 BPL   goser3
0462 01F0 C9 91                 CMP   #xon                     ;Don't echo ^Q
0463 01F2 F0 10                 BEQ   goser3
0464 01F4              *
0465 01F4 AC 15 C0              LDY   |RDCXROM
0466 01F7 5A                    PHY   
0467 01F8 8D 07 C0              STA   |SETINTCXROM
0468 01FB 20 97 F8              JSR   |COUT1                   ;Echo it 
0469 01FE 7A                    PLY   
0470 01FF 30 03                 BMI   goser3
0471 0201 8D 06 C0              STA   |SETSLOTCXROM
0472 0204              *
0473 0204              GOSER3   EQU   *                        ;Go to serout3
0474 0204              *
0475 0204              * Check if buffering is enabled
0476 0204              *
0477 0204 A8                    TAY   
0478 0205 BD B8 05              LDA   |sermode2,x
0479 0208 89 40                 BIT   #BfrngMask
0480 020A 08                    PHP   
0481 020B 98                    TYA                            ;Get back the char
0482 020C 28                    PLP   
0483 020D F0 43                 BEQ   serout3
0484 020F              *
0485 020F              * Handle the buffering case...
0486 020F              * If the queue is empty, and we are in "flow" mode, and if the 
0487 020F              *  transmit buffer is empty, we want to send it out NOW.
0488 020F              *
0489 020F 08                    PHP   
0490 0210 78                    SEI                            ;Don't risk reentrancy problems
0491 0211 48                    PHA                            ;Push the character into saveland
0492 0212 8B                    PHB                            ;DBR is currently =$00
0493 0213              *
0494 0213 38                    SEC   
0495 0214 20 9D 0B              JSR   QLength                  ;Get the length of the output queue
0496 0217 E2 30                 SEP   #%00110000
0497 0219 D0 20                 BNE   mser3                    ;If Q has chars, q this'un too
0498 021B              *
0499 021B AB                    PLB                            ;Get back DBR=$00
0500 021C BD B8 05              LDA   |sermode2,x
0501 021F 89 02                 BIT   #OutFloMask              ;Are we flowing chars?
0502 0221 D0 19                 BNE   mser2                    ;Nope, just queue the thing
0503 0223              *
0504 0223 BD 38 07              LDA   |flags,x                 ;See if awaiting XOFF
0505 0226 89 02                 BIT   #WaitXMask
0506 0228 D0 12                 BNE   mser2                    ;If so, just queue it
0507 022A              *
0508 022A BF DE 05 FF           LDA   >FFDEVLBL-$C1,x          ;Get the hardware index
0509 022E A8                    TAY   
0510 022F B9 FD BF              LDA   SCCCmd,y
0511 0232 89 04                 BIT   #%00000100               ;Is transmit buffer available?
0512 0234 F0 06                 BEQ   mser2                    ;If not, just queue it
0513 0236              *
0514 0236              * Send out this character
0515 0236              *
0516 0236 68                    PLA                            ;What was it again?
0517 0237 28                    PLP                            ;Restore interrupt state
0518 0238 80 1F                 BRA   nocheck                  ;Send char and CR check stuff
0519 023A              *
0520 023A              SERDONE  EQU   *
0521 023A 60                    RTS   
0522 023B              *
0523 023B              MSER3    EQU   *
0524 023B AB                    PLB                            ;Get back DBR=$00
0525 023C              MSER2    EQU   *
0526 023C 68                    PLA                            ;Get back the character
0527 023D              *
0528 023D              * Keep trying to queue the character until there's room.
0529 023D              *  Don't open any interrupt window until after the first try,
0530 023D              *  since an interrupt might happen before we get the character into
0531 023D              *  the queue, and if the queue was empty we would never get another
0532 023D              *  interrupt.
0533 023D              *
0534 023D              MSER     EQU   *
0535 023D 38                    SEC                            ;Want to throw in out pile
0536 023E 20 F8 0A              JSR   EnQueue
0537 0241 90 04                 BCC   mser4
0538 0243 28                    PLP                            ;Maybe reenable interrupts
0539 0244 08                    PHP                            ;Everything in its place...
0540 0245 80 F6                 BRA   mser
0541 0247              MSER4    EQU   *
0542 0247 28                    PLP                            ;Straighten up stack (int state)
0543 0248 48                    PHA                            ;Keep stack access balanced
0544 0249              *
0545 0249              * Increment the column counter (this code is duplicated in serout3...)
0546 0249              *
0547 0249 89 60                 BIT   #%01100000
0548 024B F0 03                 BEQ   mser5
0549 024D FE B8 06              INC   |col,x
0550 0250              MSER5    EQU   *
0551 0250 80 49                 BRA   crcheck                  ;Do crstuffing...
0552 0252              *
0553 0252                       EJECT 
0554 0252              ****************************************
0555 0252              *
0556 0252              * SEROUT3 - Outputs a character to the SCC
0557 0252              *            Use the nocheck entry point
0558 0252              *             to avoid the handshake check
0559 0252              *
0560 0252              * Inputs: A = char, X = Cn
0561 0252              *
0562 0252              ****************************************
0563 0252              SEROUT3  EQU   *
0564 0252 48                    PHA                            ;Save the char
0565 0253              SORDY    EQU   *
0566 0253              *
0567 0253              * Wait until the hardware we are watching is ready (TxRDY,DSR,DCD)
0568 0253              *
0569 0253 20 B2 02              JSR   HardCheck
0570 0256 90 FB                 BCC   sordy
0571 0258              *
0572 0258 68                    PLA   
0573 0259              *
0574 0259              NOCHECK  EQU   *
0575 0259 48                    PHA                            ;Save away character
0576 025A              *
0577 025A              * If this is a control character we don't want to inc the column counter
0578 025A              * 
0579 025A 89 60                 BIT   #%01100000               ;Control char?
0580 025C F0 03                 BEQ   sonxt                    ;Don't inc column if so
0581 025E FE B8 06              INC   |col,x
0582 0261              *
0583 0261              * Check to see if buffering is on
0584 0261              *
0585 0261              SONXT    EQU   *
0586 0261 BD B8 05              LDA   |sermode2,x              ;Is port interrupt driven?
0587 0264 89 40                 BIT   #BfrngMask
0588 0266 D0 1C                 BNE   sook                     ;If buffering, XON/XOFF dealt with
0589 0268              *
0590 0268              * If AppleTalk, don't stop for XON/XOFF
0591 0268              *
0592 0268 BF D5 14 E1           LDA   >ApTalkFlag,x
0593 026C 30 16                 BMI   sook
0594 026E              *
0595 026E              * If we're not buffering, see if we're doing XON/XOFF
0596 026E              *
0597 026E BD 38 07              LDA   |flags,x
0598 0271 89 20                 BIT   #XMask
0599 0273 F0 0F                 BEQ   sook                     ;Branch if not
0600 0275              *
0601 0275              * See if there's a receive character (it might be XON...)
0602 0275              *
0603 0275 20 16 03              JSR   xrdnobuf                 ;Get a char from the acia
0604 0278 90 03                 BCC   sotst                    ;Branch if no char
0605 027A              *
0606 027A              * We've got to keep this character around. Save in one char buffer.
0607 027A              *
0608 027A 20 ED 0D              JSR   FlagOBB                  ;A has the character
0609 027D              *
0610 027D              * Are we in the middle of XOFF?  Back to looping if so.
0611 027D              *
0612 027D BD 38 07     SOTST    LDA   |flags,x                 ;Check if in xoff
0613 0280 29 02                 AND   #WaitXMask
0614 0282 D0 CF                 BNE   sordy                    ;Loop if not ready
0615 0284              *
0616 0284              * Everything is totally wonderful. Kiss it goodbye and send it out
0617 0284              *  into the cold, serial (cereal?) world.
0618 0284              *
0619 0284              SOOK     EQU   *
0620 0284 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
0621 0288 A8                    TAY   
0622 0289              *
0623 0289              * Gotta decide if it goes to AppleTalk or the SCC directly. Call the
0624 0289              *  AppleTalk OUT routine if appropriate.  
0625 0289              *
0626 0289 BF D5 14 E1           LDA   >ApTalkFlag,x
0627 028D 2A                    ROL   a                        ;AppleTalk mode in C
0628 028E 68                    PLA   
0629 028F 48                    PHA                            ;Get char to XMIT
0630 0290 90 06                 BCC   regler                   ;If AT bit was clear, go right to SCC
0631 0292 22 2A 10 E1           JSL   >ATOut                   ;Send to AppleTalk land
0632 0296 80 03                 BRA   crcheck
0633 0298              *
0634 0298              REGLER   EQU   *
0635 0298 99 FF BF              STA   SCCData,y                ;Out it goes
0636 029B              *
0637 029B              * Now if that guy was a CR, we may want to send a LF to keep him/her
0638 029B              *  company.  Check whether LFs are supposed to be generated after CR.
0639 029B              *
0640 029B              CRCHECK  EQU   *
0641 029B 3C 38 07              BIT   |flags,x                 ;V=1 if LF after CR
0642 029E 49 0D                 EOR   #$0D                     ;check for CR. 
0643 02A0 0A                    ASL   A                        ;preserve bit 7 
0644 02A1 D0 0D                 BNE   sodone                   ;branch if not CR. 
0645 02A3 50 06                 BVC   clrcol                   ;branch if no LF after CR 
0646 02A5              *skp 2
0647 02A5              *bit :sermode3,X ;test for ZAP mode
0648 02A5              *bmi clrcol ;if ZAP mode then NO!!!! line feeds.
0649 02A5              *skp 2
0650 02A5 A9 14                 LDA   #$14                     ;Get LF*2
0651 02A7 6A                    ROR   A                        ;no shift in high bit 
0652 02A8              *
0653 02A8              * Send out the LF, clear the cursor position and the column counter,
0654 02A8              *  wrap things up and have a nice day.
0655 02A8              *
0656 02A8 20 04 02              JSR   goser3                   ;Output the LF but don't echo it 
0657 02AB 64 24        CLRCOL   STZ   ch                       ;0 position & column
0658 02AD 9E B8 06              STZ   |col,x
0659 02B0 68           SODONE   PLA                            ;Get the char back
0660 02B1 60                    RTS   
0661 02B2              *
0662 02B2                       EJECT 
0663 02B2              *********************************************
0664 02B2              *
0665 02B2              * HardCheck       Check handshake lines
0666 02B2              *
0667 02B2              *  This gets the current status, and
0668 02B2              * returns carry set if all conditions
0669 02B2              * handshaked on are asserted (DCD,DSR).
0670 02B2              * Tx ready is always checked.
0671 02B2              * The outflow bit is NOT changed due to the
0672 02B2              * Tx ready line.
0673 02B2              *
0674 02B2              *********************************************
0675 02B2              *
0676 02B2              HARDCHECK EQU   *
0677 02B2              *
0678 02B2              * Get the status, and flip the sense of all bits in question.
0679 02B2              *
0680 02B2 20 7C C1              JSR   getstat
0681 02B5 18                    CLC                            ;Anticipate not ready
0682 02B6 49 2C                 EOR   #%00101100
0683 02B8              *
0684 02B8              * Check if we're supposed to handshake on DSR
0685 02B8              *
0686 02B8 EB                    XBA                            ;Keep the status in a safe place
0687 02B9 BD 38 07              LDA   |flags,x
0688 02BC 89 04                 BIT   #DSRHSMask
0689 02BE F0 06                 BEQ   hc1                      ;Don't check this line...
0690 02C0              *
0691 02C0              * This line must be asserted
0692 02C0              *
0693 02C0 EB                    XBA                            ;Get back status byte
0694 02C1 89 20                 BIT   #%00100000
0695 02C3 D0 14                 BNE   HCNoGo                   ;DSR LINE was lo... forget it
0696 02C5 EB                    XBA                            ;Stuff back the status byte
0697 02C6              *
0698 02C6              * Now see if we're to handshake on the DCD line
0699 02C6              *
0700 02C6              HC1      EQU   *
0701 02C6 BD B8 05              LDA   |sermode2,x
0702 02C9 89 20                 BIT   #DCDHSMask
0703 02CB F0 06                 BEQ   hc2                      ;Don't look... it's okay
0704 02CD              *
0705 02CD              * Get back the status of the lines and check for DCD
0706 02CD              *
0707 02CD EB                    XBA   
0708 02CE 89 08                 BIT   #%00001000
0709 02D0 D0 07                 BNE   HCNoGo                   ;DCD was lo... forget it
0710 02D2 EB                    XBA                            ;Hide the status again
0711 02D3              *
0712 02D3              HC2      EQU   *
0713 02D3 EB                    XBA                            ;Pull out the SCC status
0714 02D4 89 04                 BIT   #%00000100
0715 02D6 D0 0D                 BNE   HCBye                    ;Exit if buffer unavailable
0716 02D8              *
0717 02D8              HCOKAY   EQU   *
0718 02D8 38                    SEC                            ;It's all wonderful... go for it
0719 02D9              HCNOGO   EQU   *
0720 02D9              *
0721 02D9              * Set the OutFloMask appropriately
0722 02D9              *
0723 02D9 BD B8 05              LDA   |sermode2,x
0724 02DC 29 FD                 AND   #OutFloMask--$FF
0725 02DE B0 02                 BCS   hcout
0726 02E0 09 02                 ORA   #OutFloMask
0727 02E2              HCOUT    EQU   *
0728 02E2 9D B8 05              STA   |sermode2,x
0729 02E5              HCBYE    EQU   *
0730 02E5 60                    RTS   
0731 02E6              *
0732 02E6              *
0733 02E6                       TITLE 'Serial Input Routines'
0734 02E6              ****************************************
0735 02E6              *
0736 02E6              *   This is the serial input routine.  Carry 
0737 02E6              * flag set indicates that returned data is 
0738 02E6              * valid.
0739 02E6              *
0740 02E6              ****************************************
0741 02E6              XRDSER   EQU   *
0742 02E6              *
0743 02E6              * If buffering is on, get the character from the buffer
0744 02E6              *
0745 02E6 BD B8 05              LDA   |sermode2,x
0746 02E9 89 40                 BIT   #BfrngMask
0747 02EB F0 16                 BEQ   xnosbuf                  ;No serial buffering
0748 02ED              *
0749 02ED              * Keep trying to get a character from the buffer until you get one.
0750 02ED              *
0751 02ED              BUFSORDY EQU   *
0752 02ED 18                    CLC   
0753 02EE 20 42 0B              JSR   DeQueue
0754 02F1 90 2E                 BCC   xrddone                  ;Exit with cc on underflow
0755 02F3 50 2C                 BVC   xrddone
0756 02F5              *
0757 02F5              * We have a "soft" underflow (less than 1/4 of the buffer to go).
0758 02F5              *  Force ourselves into "in flow" mode.
0759 02F5              *
0760 02F5 48                    PHA   
0761 02F6 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
0762 02FA A8                    TAY                            ;Get SCC index
0763 02FB 18                    CLC   
0764 02FC 20 2C 0A              JSR   ChgHS                    ;Carry was already cleared
0765 02FF 68                    PLA   
0766 0300              XRNOCHR  EQU   *
0767 0300 38                    SEC   
0768 0301 80 1E                 BRA   xrddone
0769 0303              *
0770 0303 BD B8 05     XNOSBUF  LDA   |sermode2,x              ;Is there a char in the one byte buffer?
0771 0306 89 10                 BIT   #ChrBufMask
0772 0308 F0 0C                 BEQ   xrdnobuf                 ;Branch if not
0773 030A 29 EF                 AND   #ChrBufMask--$FF         ;Clear the bit
0774 030C 9D B8 05              STA   |sermode2,x
0775 030F BF D7 14 E1           LDA   >OneByteBuf,x
0776 0313 38                    SEC   
0777 0314 80 0B                 BRA   xrddone
0778 0316              *
0779 0316 20 7C C1     XRDNOBUF JSR   getstat                  ;Get ACIA status
0780 0319 29 01                 AND   #$01                     ;Is there Rx data?
0781 031B 18                    CLC                            ;indicate no data
0782 031C F0 03                 BEQ   xrddone                  ;Branch if no data!
0783 031E 20 24 03              JSR   getdata                  ;Get data and check xon, etc
0784 0321              XRDDONE  EQU   *
0785 0321 60                    RTS   
0786 0322              *
0787 0322              FFCHARPTR EQU   *-$C1                   ;Pointer to character buffers
0788 0322 00 80                 DC B:$0,$80
0789 0324                       EJECT 
0790 0324              ****************************************
0791 0324              *
0792 0324              * GETDATA - Gets data from serial port
0793 0324              * and checks for LF, XON, XOFF
0794 0324              * inputs: Y = index to SCC, X = Port index
0795 0324              * outputs: A = data, Y dest, C = 1 if data ok = 0 if eaten
0796 0324              *
0797 0324              ****************************************
0798 0324              GETDATA  EQU   *
0799 0324              *
0800 0324              * If the AppleTalk bit is on, get the data from AppleTalk...
0801 0324              *
0802 0324 BF D5 14 E1           LDA   >ApTalkFlag,x
0803 0328 10 06                 BPL   gd1
0804 032A              *
0805 032A 22 2E 10 E1           JSL   >ATIn
0806 032E 80 08                 BRA   gdne1
0807 0330              *
0808 0330              GD1      EQU   *
0809 0330              *
0810 0330              * Check if this character has a framing or parity error
0811 0330              *
0812 0330 20 61 03              JSR   CheckError
0813 0333 90 2B                 BCC   gdrts                    ;If carry clear, the char was errant
0814 0335              GDNE     EQU   *
0815 0335 B9 FF BF              LDA   SCCData,y                ;Get the non-errant character
0816 0338              GDNE1    EQU   *
0817 0338              *
0818 0338              * Check for linefeeds and XON,XOFF
0819 0338              *
0820 0338 48                    PHA   
0821 0339 09 80                 ORA   #$80                     ;Set D7 for compares
0822 033B A8                    TAY   
0823 033C BD 38 07              LDA   |flags,x                 ;Get options byte
0824 033F 89 08                 BIT   #MaskLFMask              ;Eat linefeeds?
0825 0341 D0 04                 BNE   gdnolf
0826 0343 C0 8A                 CPY   #lfeed                   ;Is it a LF?
0827 0345 F0 12                 BEQ   gdeat                    ;Eat it if it is
0828 0347 89 20        GDNOLF   BIT   #XMask                   ;Xon/XOFF enabled?
0829 0349 F0 10                 BEQ   gdok
0830 034B C0 91                 CPY   #xon                     ;Is it an XON?
0831 034D D0 04                 BNE   gdnxon
0832 034F 29 FD                 AND   #WaitXMask--$FF          ;Clear xoff bit
0833 0351 80 06                 BRA   gdeat                    ;And eat it
0834 0353 C0 93        GDNXON   CPY   #xoff
0835 0355 D0 04                 BNE   gdok
0836 0357 09 02                 ORA   #WaitXMask               ;Set xoff bit
0837 0359 18           GDEAT    CLC   
0838 035A B0                    OPCODE BCS                     ;$90 opcode
0839 035B 38           GDOK     SEC   
0840 035C 9D 38 07              STA   |flags,x
0841 035F 68                    PLA   
0842 0360              GDRTS    EQU   *
0843 0360 60                    RTS   
0844 0361              *
0845 0361              *
0846 0361              CHECKERROR EQU   *
0847 0361              *
0848 0361              * See if the next char had an error.  If there was an error, and
0849 0361              *  the error mode bit is clear, eat the char and return carry clear.
0850 0361              *  Otherwise return carry set.
0851 0361              *
0852 0361 38                    SEC                            ;Default no error condition
0853 0362 BD 38 05              LDA   |sermode3,x              ;Check the error flag
0854 0365 29 02                 AND   #EMask
0855 0367 D0 13                 BNE   ceout                    ;If mode bit set, no char has errors
0856 0369              *
0857 0369 A9 01                 LDA   #1
0858 036B 20 D0 0D              JSR   ReadSCC
0859 036E 29 50                 AND   #%01010000               ;Check for parity or framing error
0860 0370 F0 0A                 BEQ   ceout                    ;If no errors, return carry set
0861 0372              *
0862 0372 1D 38 05              ORA   |sermode3,x              ;Save scoop on this errant data
0863 0375 9D 38 05              STA   |sermode3,x
0864 0378 B9 FF BF              LDA   SCCData,y                ;Throw away errant byte
0865 037B 18                    CLC                            ;Flag what we did
0866 037C              CEOUT    EQU   *
0867 037C 60                    RTS   
0868 037D              *
0869 037D              *
0870 037D                       TITLE 'Command processor for serial & comm ports'
0871 037D              *
0872 037D              CHARCR   EQU   $0D
0873 037D              UCSPACE  EQU   $00                      ;need an "upper case" space character
0874 037D              *
0875 037D              COMMAND  EQU   *
0876 037D              *
0877 037D              * Check to see if we're in the middle of a command.  Skip out if so.
0878 037D              *
0879 037D 48                    PHA                            ;shove character on stack
0880 037E 3C B8 04              BIT   |sermode,x               ;Already in command?
0881 0381 30 1F                 BMI   incmd                    ;If so, go do it
0882 0383              *
0883 0383              * Get the escape character that we currently recognize and see if
0884 0383              *  the current char matches.  If the escape char is null, no commands
0885 0383              *  are allowed.  If this isn't a command char, return with carry set.
0886 0383              *
0887 0383 BC 38 05              LDY   |sermode3,x              ;If msb = 1 ignore commands
0888 0386 30 17                 BMI   nocmd
0889 0388 5D 38 04              EOR   |eschar,x                ;Is it the command char?
0890 038B 0A                    ASL   A                        ;Ignore high bit
0891 038C D0 11                 BNE   nocmd                    ;char not command char
0892 038E              *
0893 038E              * Save away the current cursor character and make it ours '?'
0894 038E              *
0895 038E AF 35 01 E1           LDA   >cursor
0896 0392 8F 8B 15 E1           STA   >oldcur
0897 0396 A9 BF                 LDA   #cmdcur                  ;Set command char
0898 0398 8F 35 01 E1           STA   >cursor
0899 039C 4C B7 04              JMP   cominit1                 ;initiate command mode
0900 039F              *
0901 039F              * The following code wraps it up with the Carry Set indicating
0902 039F              *  that the character was not interpreted as part of a command.
0903 039F              *
0904 039F 38           NOCMD    SEC                            ;Mark char not handled
0905 03A0 68           NOCMD2   PLA                            ;Restore original char
0906 03A1 60                    RTS   
0907 03A2              *
0908 03A2              * We're somewhere in the middle of a command.  Upshift the char.
0909 03A2              *
0910 03A2              INCMD    EQU   *                        ;Command mode
0911 03A2 EB                    XBA   
0912 03A3 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
0913 03A7 A8                    TAY   
0914 03A8 EB                    XBA   
0915 03A9 29 5F                 AND   #$5F                     ;High bit doesn't matter, upshift lower case 
0916 03AB              *
0917 03AB              * See if we're in the middle of a 2 character command.
0918 03AB              *
0919 03AB 48                    PHA                            ;save character
0920 03AC BD B8 04              LDA   |sermode,x               ;need to see if in 2-chr command
0921 03AF 89 08                 BIT   #$08                     ;bit 3 set if so
0922 03B1 D0 03                 BNE   incmd2                   ;branch if so
0923 03B3 68                    PLA                            ;pull char back, not in 2-chr cmd
0924 03B4 80 5F                 BRA   incmd1                   ;go on with regular command mode
0925 03B6              *
0926 03B6              * Handle the 2nd chr of a 2 chr cmd.  Ignore spaces in 2 char commands.
0927 03B6              *
0928 03B6              INCMD2   EQU   *
0929 03B6 68                    PLA                            ;pull char off stack
0930 03B7 48                    PHA                            ; & reshove it to keep stack neat
0931 03B8 C9 00                 CMP   #ucspace                 ;is it a space? (uppercased)
0932 03BA D0 04                 BNE   incmd3                   ;no, go on with 2-chr cmd handling
0933 03BC 18                    CLC                            ;yes, ignore spaces between chrs of 2-chr cmds
0934 03BD 68                    PLA                            ;pull uppercased char off stack
0935 03BE 80 E0                 BRA   nocmd2                   ;ie mark them "handled" & don't do anything else
0936 03C0              *
0937 03C0              * Get out the index for which command we're in, then clear it out
0938 03C0              *
0939 03C0 BD B8 04     INCMD3   LDA   |sermode,x               ;get sermode back
0940 03C3 48                    PHA                            ;save sermode for a minit
0941 03C4 29 07                 AND   #7                       ;throw out all but bits 0-2
0942 03C6 9D B8 03              STA   |temp,x                  ;save - this is index of which cmd it is
0943 03C9 68                    PLA                            ;get sermode back
0944 03CA 29 F0                 AND   #$F0                     ;now clear bits 0-3
0945 03CC 9D B8 04              STA   |sermode,x               ;since we're done with them now
0946 03CF              *
0947 03CF              * Look for an E (enable) or D (disable) and branch appropriately
0948 03CF              *
0949 03CF 68                    PLA                            ;get character back
0950 03D0 DA                    PHX                            ;shove x (Cn) on stack
0951 03D1 48                    PHA   
0952 03D2 BD B8 03              LDA   |temp,x                  ;Get index to command's 1st char
0953 03D5 AA                    TAX   
0954 03D6 68                    PLA   
0955 03D7 C9 45                 CMP   #$45                     ;is it an E?
0956 03D9 D0 03                 BNE   nenable                  ;yes
0957 03DB 4C 5F 04              JMP   enable                   ;Couldn't quite reach
0958 03DE              NENABLE  EQU   *
0959 03DE C9 44                 CMP   #$44                     ;no, is it a D?
0960 03E0 F0 7F                 BEQ   disable                  ;yes
0961 03E2              *
0962 03E2              * Check if it was really a one char command followed by another command
0963 03E2              *
0964 03E2 FA                    PLX                            ;retrieve X=Cn (old X still hanging around in temp)
0965 03E3 DA                    PHX                            ;push it back to keep stack neat
0966 03E4 DD 38 04              CMP   |eschar,x                ;compare to the command character
0967 03E7 08                    PHP                            ;save result of comparison for a bit
0968 03E8 48                    PHA   
0969 03E9 BD B8 03              LDA   |temp,x                  ;Get back command index
0970 03EC AA                    TAX   
0971 03ED 68                    PLA   
0972 03EE 28                    PLP                            ;retrieve result of comparison of char to cmd char
0973 03EF F0 15                 BEQ   flagit                   ;yes tis 1-chr cmd followd by nother cmd
0974 03F1              *
0975 03F1              * Maybe this char is a carriage return. Then it was really a 1 chr cmd
0976 03F1              *
0977 03F1 C9 0D                 CMP   #charCR                  ;is it a (guess what) CR?
0978 03F3 F0 1A                 BEQ   oneletter                ;yes - a 1-chr command
0979 03F5              *
0980 03F5              * This is an unimplemented but legal 2-chr command.
0981 03F5              *  Restore the cursor and clear the 'in-the-middle-of-a-command' bit.
0982 03F5              *
0983 03F5              CMD2NULL EQU   *
0984 03F5 FA                    PLX                            ;pull x (Cn) off stack
0985 03F6 AF 8B 15 E1           LDA   >oldcur                  ;restore non-cmd-mode cursor
0986 03FA 8F 35 01 E1           STA   >cursor
0987 03FE 1E B8 04              ASL   |sermode,x               ;clear cmd-mode bit (bit 7 of sermode)
0988 0401 5E B8 04              LSR   |sermode,x               ;by shifting out bit 7 & shifting in a 0
0989 0404 80 99                 BRA   nocmd                    ;return marking character not handled
0990 0406              *
0991 0406              * Here we have gotten an an escape char after L, X, F, M, or T.
0992 0406              *  This means that we should do the pending command and remain in
0993 0406              *  in command mode for the next yet to be received command.
0994 0406              *
0995 0406              FLAGIT   EQU   *
0996 0406 FA                    PLX                            ;need X=Cn to set bit 0 of sermode
0997 0407 DA                    PHX                            ;but leave Cn on stack too
0998 0408 FE B8 04              INC   |sermode,x               ;bit 0 was 0, now's 1 - means new cmd mode
0999 040B BD B8 03              LDA   |temp,x                  ;Reload X index to cmds 1st chr
1000 040E AA                    TAX   
1001 040F              *
1002 040F              ONELETTER EQU   *                       ;come here if 2-chr cmd turns out 1 chr
1003 040F BF 97 06 FF           LDA   >cmd2list,x              ;get command chr
1004 0413 80 0C                 BRA   backto1                  ;treat it as if we just got it
1005 0415              *
1006 0415              *
1007 0415              *
1008 0415              INCMD1   EQU   *                        ;in command mode, not 2-chrs tho
1009 0415 DA                    PHX                            ;Save slot
1010 0416 A2 07                 LDX   #7                       ;check 8 possible 2-chr cmds
1011 0418 DF 97 06 FF  CMD2LOOP CMP   >cmd2list,x              ;is it there?
1012 041C F0 73                 BEQ   cmd2found                ;yes, need to flag it for next time
1013 041E CA                    DEX                            ;nope
1014 041F 10 F7                 BPL   cmd2loop                 ;try next if there is one
1015 0421              *
1016 0421              * Check for one character commands
1017 0421              *
1018 0421              BACKTO1  EQU   *
1019 0421 A2 0C                 LDX   #12                      ;Check 13 commands
1020 0423 DF 8A 06 FF  CMDLOOP  CMP   >cmdlist,x
1021 0427 D0 03                 BNE   noreach                  ;Right char?
1022 0429 4C AE 04              JMP   cmdfound
1023 042C              NOREACH  EQU   *
1024 042C CA                    DEX   
1025 042D 10 F4                 BPL   cmdloop
1026 042F              *
1027 042F              * We haven't found it in the one char table.  If it is a control char
1028 042F              *  then we will make it our new escape character.
1029 042F              *
1030 042F FA                    PLX                            ;We didn't find it
1031 0430 68                    PLA   
1032 0431 48                    PHA   
1033 0432 29 7F                 AND   #$7F                     ;if char is cntl char 
1034 0434 C9 20                 CMP   #$20                     ;it can be the new comd char 
1035 0436 B0 03                 BCS   ckdig                    ;branch if not cntl character 
1036 0438 9D 38 04     CMDZ2    STA   |eschar,x                ;Save comd char, drop thru ckdig to cdone 
1037 043B              *
1038 043B              * Maybe it's a number... if so shift the number buffer by 10 and add
1039 043B              *  the new digit.
1040 043B              *
1041 043B 49 30        CKDIG    EOR   #$30                     ;zap it down to 0n if char was a digit
1042 043D C9 0A                 CMP   #$0A                     ;if not a digit, it is unexpected intruder
1043 043F B0 38                 BGE   cdone                    ;If not, branch
1044 0441 A0 0A                 LDY   #10                      ;A = A + 10 * current number
1045 0443 6F 8A 15 E1  DIGLOOP  ADC   >number                  ;C=0 on first entry
1046 0447 88                    DEY   
1047 0448 D0 F9                 BNE   digloop
1048 044A              *
1049 044A              * Now remember that we have seen a number this command.
1050 044A              *
1051 044A 48                    PHA   
1052 044B A9 80                 LDA   #nflagmask
1053 044D 1D B8 05              ORA   |sermode2,x
1054 0450 9D B8 05              STA   |sermode2,x
1055 0453 68                    PLA   
1056 0454              *
1057 0454              * The acc now has the new number value.  Branch to save it...
1058 0454              *
1059 0454 80 73                 BRA   cominit                  ;not starting new cmd mode, just save #
1060 0456              *
1061 0456              * This handles LE and LD... make them look like L and K respectively.
1062 0456              *
1063 0456              CMD2L    EQU   *                        ;come here to handle LE & LD
1064 0456 A9 4C                 LDA   #$4C                     ;make LE look like L
1065 0458 28                    PLP                            ;get P back with carry indicating E or D
1066 0459 B0 C6                 BCS   backto1                  ;carry set means it was an E
1067 045B A9 4B                 LDA   #$4B                     ;make LD look like K
1068 045D 80 C2                 BRA   backto1
1069 045F              *
1070 045F              * These guys turn on or off one of the mode flags per E/D.
1071 045F              *
1072 045F              ENABLE   EQU   *                        ;got a 2-chr command aE
1073 045F 38                    SEC                            ;set carry
1074 0460 90                    OPCODE BCC                     ;bcc to skip next byte (the CLC)
1075 0461              DISABLE  EQU   *                        ;got a 2-chr command aD
1076 0461 18                    CLC                            ;clear carry
1077 0462 08                    PHP                            ;push P to save carry
1078 0463 E0 00                 CPX   #0                       ;if X=0 then command is LE or LD
1079 0465 F0 EF                 BEQ   cmd2l                    ;so just make it act like L or K
1080 0467 E0 07                 CPX   #7
1081 0469 D0 03                 BNE   di3
1082 046B 4C 52 06              JMP   cmd_a                    ;Process the A command
1083 046E              DI3      EQU   *
1084 046E E0 06                 CPX   #6                       ;if X=6 then command is CE or CD
1085 0470 F0 5E                 BEQ   cmd_c
1086 0472 E0 05                 CPX   #5                       ;if X=5 then command is BE or BD
1087 0474 F0 78                 BEQ   cmd_b
1088 0476 4C E1 04              JMP   xr1                      ;Deal with the rest
1089 0479              *
1090 0479              * Look at sermode[0] to see if we should set or clear command mode.
1091 0479              *
1092 0479              CDONE    EQU   *
1093 0479 BD B8 04              LDA   |sermode,x               ;so get it
1094 047C 4A                    LSR   A                        ;shift bit 0 to carry
1095 047D B0 38                 BCS   cominit1                 ;if set, start new cmd mode
1096 047F              *
1097 047F              * Put the cursor back the way we found it
1098 047F              *
1099 047F AF 8B 15 E1           LDA   >oldcur                  ;Restore the cursor
1100 0483 8F 35 01 E1           STA   >cursor                  ;& fall through to cmset with carry clear
1101 0487              *
1102 0487              * Set the command mode per the carry
1103 0487              *
1104 0487 08           CMSET    PHP   
1105 0488 1E B8 04              ASL   |sermode,x               ;set command mode according to carry 
1106 048B 28                    PLP   
1107 048C              *
1108 048C              * Clear the carry (indicating the char was handled), get the char back,
1109 048C              *  and return.
1110 048C              *
1111 048C 7E B8 04              ROR   |sermode,x               ;leaves carry clear 
1112 048F 68                    PLA                            ;character handled 
1113 0490 60                    RTS                            ;because carry clear... 
1114 0491              *
1115 0491              *
1116 0491              CMD2FOUND EQU   *
1117 0491 C9 42                 CMP   #'B'                     ;This char can be two char cmd
1118 0493 D0 0C                 BNE   c2fcont
1119 0495              *
1120 0495              * In the case of encountering the 'B' command, if there was a
1121 0495              *  number preceding the 'B', then it's the one character baud rate
1122 0495              *  change command.  Otherwise it is likely to be the two character
1123 0495              *  buffering enable/disable command.
1124 0495              *
1125 0495 8A                    TXA   
1126 0496 FA                    PLX   
1127 0497 DA                    PHX   
1128 0498 48                    PHA                            ;Save the index
1129 0499 BD B8 05              LDA   |sermode2,x
1130 049C FA                    PLX   
1131 049D 89 80                 BIT   #nflagmask
1132 049F D0 0D                 BNE   cmdfound                 ;It's BAUD: X is 5 already
1133 04A1              *
1134 04A1              C2FCONT  EQU   *
1135 04A1 8A                    TXA                            ;copy index of cmd to acc
1136 04A2 FA                    PLX                            ;restore X to Cn
1137 04A3 1D B8 04              ORA   |sermode,x               ;copy top 2 bits of sermode
1138 04A6 09 08                 ORA   #$08                     ;& set bit 3 - 2-chr-command-mode flag
1139 04A8 9D B8 04              STA   |sermode,x               ;sermode now holds index to 2-chr command issued
1140 04AB 38                    SEC                            ;set carry so we stay in command mode
1141 04AC 80 D9                 BRA   cmset                    ;for next time
1142 04AE              *
1143 04AE              *
1144 04AE              CMDFOUND EQU   *
1145 04AE A9 05                 LDA   #>cmdcr                  ;get hi byte of where to go
1146 04B0 48                    PHA                            ;save it on stack
1147 04B1 BF 63 06 FF           LDA   >cmdtable,x              ;get lo byte of where to go
1148 04B5 48                    PHA                            ;save it on stack
1149 04B6 60                    RTS                            ;go there by RTSing
1150 04B7              *
1151 04B7              * Init command mode by setting sermode, clearing number and exit
1152 04B7              *
1153 04B7              COMINIT1 EQU   *                        ;start new cmd mode here
1154 04B7 BD B8 04              LDA   |sermode,x               ;get sermode
1155 04BA 29 C0                 AND   #$C0                     ;clear bits 0-5 (starting a new cmd seq --
1156 04BC 9D B8 04              STA   |sermode,x               ;they are used for misc during cmd mode)
1157 04BF BD B8 05              LDA   |sermode2,x              ;Clear out the 'seen a number' bit
1158 04C2 29 7F                 AND   #nflagmask--$FF
1159 04C4 9D B8 05              STA   |sermode2,x
1160 04C7 A9 00                 LDA   #0                       ;load a 0 to stuff in NUMBER
1161 04C9 8F 8A 15 E1  COMINIT  STA   >number
1162 04CD 38                    SEC                            ;Mark in command mode
1163 04CE 80 B7                 BRA   cmset
1164 04D0              *
1165 04D0              * This is the CE/D service
1166 04D0              *
1167 04D0 28           CMD_C    PLP                            ;restore status to check carry bit
1168 04D1 FA                    PLX   
1169 04D2 A9 F7                 LDA   #crstuffmask--$FF
1170 04D4 3D B8 05              AND   |sermode2,x
1171 04D7 90 02                 BCC   cmd_c1
1172 04D9 09 08                 ORA   #crstuffmask
1173 04DB              CMD_C1   EQU   *
1174 04DB 9D B8 05              STA   |sermode2,x
1175 04DE 4C 79 04     CDONE3   JMP   cdone                    ;we're done here
1176 04E1              *
1177 04E1              *
1178 04E1              ***********************************************
1179 04E1              * for other 2-chr cmds, their FLAGS masks' indexes are 2X+3      
1180 04E1              * for an E or 2X+4 for a D    
1181 04E1              ***********************************************
1182 04E1              *
1183 04E1              XR1      EQU   *
1184 04E1 8A                    TXA                            ;copy x to acc for arithmetic
1185 04E2 18                    CLC                            ;clear carry for arithmetic
1186 04E3 0A                    ASL   A                        ;multiply index by 2
1187 04E4 69 03                 ADC   #3                       ;add 3 to get mask index
1188 04E6 AA                    TAX                            ;put mask index in X
1189 04E7 28                    PLP                            ;get carry back
1190 04E8 B0 01                 BCS   xready                   ;carry set = Enable so X is ready
1191 04EA E8                    INX                            ;cmd was Disable so inc X to next mask
1192 04EB 4C 31 05     XREADY   JMP   cmdi                     ;go do mask stuff to FLAGS
1193 04EE              *
1194 04EE              * We have gotten a BE/D command.
1195 04EE              *
1196 04EE              CMD_B    EQU   *
1197 04EE 28                    PLP                            ;Get back enable/disable request
1198 04EF FA                    PLX                            ;Get back $CN
1199 04F0              *
1200 04F0 08                    PHP                            ;Disable int until they're dead
1201 04F1 78                    SEI   
1202 04F2              *
1203 04F2 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x          ;Get hardware index
1204 04F6 A8                    TAY   
1205 04F7              *
1206 04F7 BD B8 05              LDA   |sermode2,x
1207 04FA 29 BF                 AND   #BfrngMask--$FF
1208 04FC              *
1209 04FC 90 02                 BCC   smc
1210 04FE              *
1211 04FE 09 40                 ORA   #BfrngMask               ;Flip on the buffering bit
1212 0500              SMC      EQU   *
1213 0500 9D B8 05              STA   |sermode2,x              ;Gotta set it before enabling ints
1214 0503              *
1215 0503 20 E0 0A              JSR   IntKill                  ;Disable and clear pending SCC interrupts
1216 0506 28                    PLP                            ;Restore interrupt state
1217 0507 90 08                 BCC   q                        ;If it was BD, skip the turn on
1218 0509              *
1219 0509 DA                    PHX   
1220 050A 20 BE 0B              JSR   ResetQs
1221 050D 20 C6 09              JSR   EnableInt
1222 0510 FA                    PLX   
1223 0511              *
1224 0511              Q        EQU   *
1225 0511 4C 41 05              JMP   cdone2
1226 0514              *
1227 0514              *
1228 0514              * Make sure the command service routines are in the same page
1229 0514              *
1230 0514              HEREC_1  EQU   *-Rel~Org+Bnk~Org
1231 0514                       IF HEREC_1 < $0518 THEN 
1232 0514 00 00 00 00           DC B:$0518-HEREC_1,0           ;Keep routines in a single page
1233 0518                       ENDIF 
1234 0518              *
1235 0518 FA           CMDZ     PLX                            ;Zero escape character
1236 0519 9E 38 06              STZ   |pwdth,x                 ;And the width
1237 051C A9 80                 LDA   #CSDMask
1238 051E 1D 38 05              ORA   |sermode3,x
1239 0521 9D 38 05              STA   |sermode3,x
1240 0524 80 1B                 BRA   cdone2
1241 0526              *
1242 0526              *
1243 0526              CMDCR    EQU   *
1244 0526              CMDN     EQU   *
1245 0526 7A                    PLY   
1246 0527 AF 8A 15 E1           LDA   >number                  ;Get number inputted
1247 052B F0 05                 BEQ   cmdi2                    ;skip if 0
1248 052D 99 38 06              STA   |pwdth,y                 ;Update printer width
1249 0530 F0                    DC B:$F0                       ;BEQ opcode to skip next byte (the PLY)
1250 0531              CMDI     EQU   *
1251 0531              CMDK     EQU   *
1252 0531              CMDL     EQU   *
1253 0531 7A                    PLY   
1254 0532 B9 38 07     CMDI2    LDA   |flags,y
1255 0535 3F 70 06 FF           AND   >mask1,x                 ;Mask off bit we'll change
1256 0539 1F 7D 06 FF           ORA   >mask2,x                 ;Change it
1257 053D 99 38 07              STA   |flags,y                 ;Back it goes
1258 0540 BB                    TYX                            ;Put slot back in x
1259 0541 4C 79 04     CDONE2   JMP   cdone                    ;Good bye
1260 0544
1261 0544
1262 0544              *
1263 0544              * Process the parity command.
1264 0544              *
1265 0544              CMDP     EQU   *
1266 0544 AF 8A 15 E1           LDA   >number                  ;0,2-no parity, 1-odd, 3-even
1267 0548 BB                    TYX   
1268 0549 5F 55 15 E1           EOR   >WR4,x                   ;Fold A[1..0] into current value
1269 054D 29 03                 AND   #%00000011               ;Only keep low bits of ACC
1270 054F              UPD4     EQU   *
1271 054F 5F 55 15 E1           EOR   >WR4,x
1272 0553 9F 55 15 E1           STA   >WR4,x
1273 0557              ISPHITCH EQU   *
1274 0557 FA                    PLX   
1275 0558 DA                    PHX                            ;Get X back for InitSerial
1276 0559 20 7C C2              JSR   InitSerialPB             ;Init Port and maybe reenable bfrng
1277 055C              HITCH    EQU   *
1278 055C FA                    PLX                            ;Get back $CN
1279 055D 80 E2                 BRA   cdone2
1280 055F              *
1281 055F              * Process a Data format change command.
1282 055F              *
1283 055F              CMDD     EQU   *
1284 055F AF 8A 15 E1           LDA   >number
1285 0563 48                    PHA   
1286 0564              *
1287 0564              * Do the Receive data bits
1288 0564              *
1289 0564 29 03                 AND   #%00000011               ;Use only the low bits
1290 0566 49 03                 EOR   #%00000011               ;Reverse the table for BASIC command
1291 0568 AA                    TAX   
1292 0569 BF 0B 0D FF           LDA   >DBitMap,x
1293 056D BB                    TYX   
1294 056E 5F 53 15 E1           EOR   >WR3,x
1295 0572 29 C0                 AND   #%11000000               ;Keep everything else the same
1296 0574 5F 53 15 E1           EOR   >WR3,x
1297 0578 9F 53 15 E1           STA   >WR3,x
1298 057C              *
1299 057C              * Do the Transmit # data bits
1300 057C              *
1301 057C 4A                    LSR   a
1302 057D 5F 57 15 E1           EOR   >WR5,x
1303 0581 29 60                 AND   #%01100000               ;Everything else is the same
1304 0583 5F 57 15 E1           EOR   >WR5,x
1305 0587 9F 57 15 E1           STA   >WR5,x
1306 058B              *
1307 058B 68                    PLA                            ;Get Number back
1308 058C 0A                    ASL   a                        ;Move up to where SCC wants it
1309 058D BB                    TYX                            ;Move the index
1310 058E 5F 55 15 E1           EOR   >WR4,x                   ;Fold the new bit into the current value
1311 0592 29 08                 AND   #%00001000               ;Only keep one bit of ACC
1312 0594              *
1313 0594 80 B9                 BRA   upd4
1314 0596              *
1315 0596              * Process the Baud Rate command.
1316 0596              *
1317 0596              CMDB     EQU   *
1318 0596 AF 8A 15 E1           LDA   >number
1319 059A D0 03                 BNE   lmc                      ;Y has the hardware index
1320 059C 20 FF 0C              JSR   FigBaud                  ;Get the default Baud rate
1321 059F              LMC      EQU   *
1322 059F 20 05 0D              JSR   StoreBaud
1323 05A2 80 B3                 BRA   ISPHitch
1324 05A4              *
1325 05A4
1326 05A4
1327 05A4              *
1328 05A4              * Send a 233 ms break character taking into account how fast the
1329 05A4              *  CPU is currently running.
1330 05A4              *
1331 05A4              CMDS     EQU   *
1332 05A4              *
1333 05A4              * Break is not supported in AppleTalk mode
1334 05A4              *
1335 05A4 FA                    PLX   
1336 05A5 DA                    PHX   
1337 05A6 BF D5 14 E1           LDA   >ApTalkFlag,x
1338 05AA 30 24                 BMI   whee
1339 05AC              *
1340 05AC BB                    TYX   
1341 05AD BF 57 15 E1           LDA   >WR5,x                   ;Get the current register value
1342 05B1 48                    PHA                            ;Save it
1343 05B2 09 10                 ORA   #$10                     ;Turn on the break bit
1344 05B4 A2 05                 LDX   #5                       ;Start the break
1345 05B6 20 C3 0D              JSR   WriteSCC
1346 05B9              *
1347 05B9 18                    CLC                            ;Start carry in known state
1348 05BA A2 F7                 LDX   #247                     ;Now delay about 233 milliseconds
1349 05BC A9 F3        BK2      LDA   #243
1350 05BE 3A           BK1      DEC   a                        ;Loop here 243 times
1351 05BF D0 FD                 BNE   bk1
1352 05C1 6A                    ROR   a                        ;Complement the carry...
1353 05C2 49 80                 EOR   #$80
1354 05C4 2A                    ROL   a
1355 05C5 B0 F5                 BCS   bk2                      ;Do the inner loop twice
1356 05C7 CA                    DEX                            ;This is the outer loop
1357 05C8 D0 F2                 BNE   bk2
1358 05CA 68                    PLA                            ;Get old value back
1359 05CB              *
1360 05CB A2 05                 LDX   #5
1361 05CD 20 C3 0D              JSR   WriteSCC
1362 05D0              WHEE     EQU   *
1363 05D0 FA                    PLX   
1364 05D1 4C 41 05              JMP   cdone2
1365 05D4              *
1366 05D4 18           CMDQ     CLC                            ;Quit terminal mode
1367 05D5 B0                    DC B:$B0                       ;BCS to skip next byte
1368 05D6 38           CMDT     SEC                            ;Into terminal mode
1369 05D7 FA                    PLX                            ;Recover X
1370 05D8 20 1D 06              JSR   setterm
1371 05DB 4C 79 04              JMP   cdone
1372 05DE              *
1373 05DE              CMDR     EQU   *
1374 05DE FA                    PLX   
1375 05DF DA                    PHX   
1376 05E0              *
1377 05E0              * Since we'll make a call to sethooks and doffsvk, we gotta
1378 05E0              *  make sure that the all the $CX00 rom space is banked in.
1379 05E0              *  We also must restore it when we're done.
1380 05E0              *
1381 05E0 AD 15 C0              LDA   |RDCXROM
1382 05E3 48                    PHA   
1383 05E4 8D 07 C0              STA   |SETINTCXROM
1384 05E7              *
1385 05E7 BD 38 05              LDA   |sermode3,x
1386 05EA 29 04                 AND   #BasicMask
1387 05EC F0 16                 BEQ   cmdrgds
1388 05EE              *
1389 05EE 18                    CLC                            ;Make sure terminal mode is off
1390 05EF 20 1D 06              JSR   setterm
1391 05F2              *
1392 05F2 AD 1F C0              LDA   |RD80VID                 ;Check if video firmware active
1393 05F5 0A                    ASL   A                        ;Save it in C
1394 05F6 20 59 CF              JSR   |SETHOOKS                ;assume video firmware active 
1395 05F9 B0 09                 BCS   cmdrgds                  ;branch if good guesser... 
1396 05FB 20 2B FB              JSR   |DOFFSVK                 ;Reset the hooks
1397 05FE A9 FF                 LDA   #$FF                     ;Slam old cursor with checkerboard
1398 0600 8F 8B 15 E1           STA   >oldcur                  ;So that code at CDONE works okay
1399 0604              *
1400 0604              * Now if buffering's on, turn it off and deallocate the buffer
1401 0604              *  First set back the slot rom the way it was
1402 0604              *
1403 0604              CMDRGDS  EQU   *
1404 0604 68                    PLA   
1405 0605 30 03                 BMI   cmg2
1406 0607 8D 06 C0              STA   |SETSLOTCXROM
1407 060A              CMG2     EQU   *
1408 060A FA                    PLX   
1409 060B DA                    PHX   
1410 060C BD B8 05              LDA   |sermode2,x
1411 060F 29 40                 AND   #bfrngmask
1412 0611 F0 BD                 BEQ   whee
1413 0613 20 E0 0A              JSR   IntKill
1414 0616 FA                    PLX   
1415 0617 DA                    PHX   
1416 0618 20 E9 06              JSR   ReleaseBuf
1417 061B 80 B3                 BRA   whee                     ;Pull X and back to the grind
1418 061D              *
1419 061D                       EJECT 
1420 061D              SETTERM  EQU   *                        ;set/clear terminal mode
1421 061D              *
1422 061D              * Here the carry is set if we're initiating terminal mode.
1423 061D              *
1424 061D BD B8 04              LDA   |sermode,x               ;Get terminal mode status
1425 0620 89 40                 BIT   #$40                     ;Z=1 if not in terminal mode
1426 0622 90 16                 BCC   stclr                    ;Branch if clearing terminal mode
1427 0624 D0 2B                 BNE   stwasok                  ;Was already set
1428 0626              *
1429 0626              * If we're not in the input hooks, don't go to terminal mode
1430 0626              *
1431 0626 E4 39                 CPX   kswh                     ;Are we in the input hooks
1432 0628 D0 27                 BNE   strts                    ;Leaves C=1 if = 
1433 062A              *
1434 062A              * Flip on the terminal mode bit
1435 062A              *
1436 062A 09 40                 ORA   #$40                     ;Set term mode bit
1437 062C              *
1438 062C              * Preserve the normal cursor and shove terminal mode cursor
1439 062C              *
1440 062C 48                    PHA   
1441 062D AF 8B 15 E1           LDA   >oldcur                  ;Save what was in oldcur
1442 0631 8F 8C 15 E1           STA   >oldcur2
1443 0635 68                    PLA   
1444 0636 A0 DF                 LDY   #termcur                 ;Get new cursor value
1445 0638 80 0B                 BRA   stset
1446 063A              *
1447 063A              * Clear terminal mode and restore the old cursor
1448 063A              *
1449 063A F0 15        STCLR    BEQ   stwasok                  ;Branch if already clear
1450 063C 29 BF                 AND   #$BF                     ;Clear the bit
1451 063E 48                    PHA   
1452 063F AF 8C 15 E1           LDA   >oldcur2                 ;Restore the cursor
1453 0643 A8                    TAY   
1454 0644 68                    PLA   
1455 0645 9D B8 04     STSET    STA   |sermode,x
1456 0648 98                    TYA                            ;Gotta do long addressing...
1457 0649 8F 8B 15 E1           STA   >oldcur                  ;Save cursor to be restored after command
1458 064D 8F 35 01 E1           STA   >cursor
1459 0651              STWASOK  EQU   *
1460 0651              *
1461 0651              * The //c firmware turned on receiver interrupts here.
1462 0651              *
1463 0651 60           STRTS    RTS   
1464 0652              *
1465 0652              *
1466 0652              CMD_A    EQU   *
1467 0652 28                    PLP   
1468 0653 FA                    PLX   
1469 0654 A9 F7                 LDA   #BTabMask--$FF
1470 0656 3D 38 05              AND   |sermode3,x
1471 0659 90 02                 BCC   cmd_a1
1472 065B 09 08                 ORA   #BTabMask
1473 065D              CMD_A1   EQU   *
1474 065D 9D 38 05              STA   |sermode3,x
1475 0660 4C 79 04              JMP   cdone
1476 0663              *
1477 0663              *
1478 0663                       MSB   OFF
1479 0663              CMDTABLE EQU   *                        ;command routines' lo bytes
1480 0663 30                    DC B:CMDI-1
1481 0664 30                    DC B:CMDK-1
1482 0665 30                    DC B:CMDL-1
1483 0666 25                    DC B:CMDN-1
1484 0667 25                    DC B:CMDCR-1
1485 0668 95                    DC B:CMDB-1
1486 0669 5E                    DC B:CMDD-1
1487 066A 43                    DC B:CMDP-1
1488 066B D3                    DC B:CMDQ-1
1489 066C DD                    DC B:CMDR-1
1490 066D A3                    DC B:CMDS-1
1491 066E D5                    DC B:CMDT-1
1492 066F 17                    DC B:CMDZ-1
1493 0670              *
1494 0670              * Flag byte
1495 0670              * masks for:     I   K   L   N   CR  XE  XD  FE  FD  ME  MD  EE  ED
1496 0670 7F BF BF 7F  MASK1    DC B:$7F,$BF,$BF,$7F,$FF,$DF,$DF,$EF,$EF,$F7,$F7,$7F,$7F
1497 067D 80 00 40 00  MASK2    DC B:$80,$00,$40,$00,$00,$20,$00,$00,$10,$00,$08,$80,$00
1498 068A              *
1499 068A              CMDLIST  EQU   *
1500 068A 49 4B 4C 4E           DC B:'IKLN'
1501 068E 0D                    DC B:$0D                       ;cr (part of cmdlist)
1502 068F 42 44 50 51           DC B:'BDPQRSTZ'
1503 0697              CMD2LIST EQU   *
1504 0697 4C 58 46 4D           DC B:'LXFMEBCA'                ;2-chr commands' first chrs
1505 069F              *
1506 069F              *
1507 069F 3C 3B        FFDEVLBL: DC B:$3C,$3B
1508 06A1              *
1509 06A1              *
1510 06A1              *
1511 06A1              * Buffer allocation routine
1512 06A1              *  If no error, carry is clear and buffer address is in A (lo), X (hi)
1513 06A1              *   Otherwise, carry is set.
1514 06A1              *
1515 06A1                       LONGA ON
1516 06A1                       LONGI ON
1517 06A1              *
1518 06A1              * Must have X set to $CN on entry!
1519 06A1              *
1520 06A1              GETBIGBUF EQU   *
1521 06A1 DA                    PHX                            ;Keep port index
1522 06A2 F4 00 00              PEA   |0                       ;Push the space for result
1523 06A5 F4 00 80              PEA   |$8000                   ;Tag field
1524 06A8              *
1525 06A8 A2 03 20              LDX   #$20*256+3               ;Get ID tag
1526 06AB 22 00 00 E1           JSL   >ToolDispatch            ; from misc tools
1527 06AF 68                    PLA                            ;Get the ID
1528 06B0 FA                    PLX                            ;And get back the index
1529 06B1 08                    PHP                            ;save the carry
1530 06B2 E0 C1 00              CPX   #$C1                     ;Tags are two bytes
1531 06B5 F0 01                 BEQ   gbb1
1532 06B7 E8                    INX   
1533 06B8              GBB1     EQU   *
1534 06B8 9F 08 15 E1           STA   >BID-$C1,x               ;Store it away
1535 06BC 28                    PLP                            ;Get back GetID results
1536 06BD B0 29                 BCS   nevermind
1537 06BF              *
1538 06BF A2 00 00              LDX   #0
1539 06C2 DA                    PHX                            ;Push space for long result
1540 06C3 DA                    PHX   
1541 06C4 DA                    PHX                            ;Hi part of size request
1542 06C5 F4 00 10              PEA   |bufsize                 ;Push size request low
1543 06C8 48                    PHA                            ;Push Owner ID we just got
1544 06C9 F4 08 40              PEA   |$4008                   ;Attributes: fixed, no spcl mem
1545 06CC DA                    PHX                            ;Location info
1546 06CD DA                    PHX                            ; top part
1547 06CE A2 02 09              LDX   #9*256+2                 ;NewHandle
1548 06D1 22 00 00 E1           JSL   >ToolDispatch            ;Call the memory manager
1549 06D5 FA                    PLX                            ;Pull low part
1550 06D6 68                    PLA                            ;Pull hi part
1551 06D7 B0 0F                 BCS   nevermind
1552 06D9              *
1553 06D9              * Dereference the handle and get the buffer address
1554 06D9              *
1555 06D9 8B                    PHB                            ;Save current DBR
1556 06DA EB                    XBA                            ;Swap so bank is pulled last
1557 06DB 48                    PHA                            ;Push bank then $00
1558 06DC AB                    PLB                            ;Pull the $00
1559 06DD AB                    PLB                            ;DBR now set for handle
1560 06DE              *
1561 06DE BD 00 00              LDA   |0,x                     ;Get low part
1562 06E1 48                    PHA   
1563 06E2 BD 02 00              LDA   |2,x                     ;Get hi part
1564 06E5 AA                    TAX   
1565 06E6 68                    PLA   
1566 06E7 AB                    PLB   
1567 06E8              *
1568 06E8              NEVERMIND EQU   *
1569 06E8 60                    RTS   
1570 06E9              *
1571 06E9              *
1572 06E9              *  This routine releases the buffer secured with the above call.
1573 06E9              *   It is called when the Reset command is set through the output flow.
1574 06E9              *
1575 06E9              *
1576 06E9              RELEASEBUF EQU   *
1577 06E9 8B                    PHB                            ;SETDBR $E1E1
1578 06EA F4 E1 E1              PEA   $E1E1
1579 06ED AB                    PLB   
1580 06EE AB                    PLB   
1581 06EF              *
1582 06EF              * Point at the input part of this channel's buffer
1583 06EF              *
1584 06EF 18                    CLC   
1585 06F0 20 1A 0C              JSR   SetQueue
1586 06F3              *
1587 06F3 C2 30                 REP   #%00110000               ;
1588 06F5 DA                    PHX                            ;Keep around a 16 bit X
1589 06F6              *
1590 06F6              * Do the call to FindHandle since we did not keep around the original
1591 06F6              *
1592 06F6 A9 00 00              LDA   #0
1593 06F9 48                    PHA   
1594 06FA 48                    PHA                            ;Space for result
1595 06FB B9 DA 1D              LDA   QBase+2,y                ;Push hi
1596 06FE 48                    PHA   
1597 06FF B9 D8 1D              LDA   QBase,y                  ;Push low
1598 0702 48                    PHA   
1599 0703 A2 02 1A              LDX   #$1A*256+2               ;FindHandle
1600 0706 22 00 00 E1           JSL   >ToolDispatch
1601 070A A3 01                 LDA   1,s                      ;If result = 0, then it's NON MM memory
1602 070C 03 03                 ORA   3,s                      ;
1603 070E 38                    SEC   
1604 070F F0 1F                 BEQ   rb3                      ;Can't release what we don't got
1605 0711              *
1606 0711              * Now attempt the disposal. The handle is already on the stack.
1607 0711              *
1608 0711 A2 02 10              LDX   #$10*256+2
1609 0714 22 00 00 E1           JSL   >ToolDispatch            ;DisposHandle
1610 0718              *bcs rb1 ;If this failed, skip out
1611 0718 B0 16                 BCS   rb3                      ;*** Bug Fix 10/7/86 ***
1612 071A              *
1613 071A              * Get back the port index and get back the buffer ID to release it.
1614 071A              *
1615 071A FA                    PLX   
1616 071B DA                    PHX   
1617 071C E0 C1 00              CPX   #$C1
1618 071F F0 01                 BEQ   rb2
1619 0721 E8                    INX                            ;Widen the index for the 2nd port
1620 0722              RB2      EQU   *
1621 0722 BF 08 15 E1           LDA   >BID-$C1,x
1622 0726 48                    PHA   
1623 0727 A2 03 21              LDX   #$21*256+3
1624 072A 22 00 00 E1           JSL   >ToolDispatch            ;DeleteID
1625 072E 80 02                 BRA   rb1
1626 0730              *
1627 0730              RB3      EQU   *
1628 0730 FA                    PLX                            ;Pull off garbage (zeros)
1629 0731 68                    PLA   
1630 0732              *
1631 0732              RB1      EQU   *
1632 0732 FA                    PLX                            ;Pull off the index
1633 0733 E2 30                 SEP   #%00110000               ;Back to 8 bit land
1634 0735 B0 03                 BCS   rberror1                 ;If error, don't clear buffer flag
1635 0737 9E 3D 0F              STZ   |firsttime-$C1,x
1636 073A              RBERROR1 EQU   *
1637 073A AB                    PLB                            ;Back to original bank
1638 073B 60                    RTS   
1639 073C              *
1640 073C              *
1641 073C                       LONGA OFF
1642 073C                       LONGI OFF
1643 073C              *
1644 073C              *
1645 073C              * Auxilliary routine that wouldn't fit anywhere else...
1646 073C              *  Sets a bit which keeps track if you are calling the BASIC or PASCAL
1647 073C              *  entry point.
1648 073C              *
1649 073C              SETBASICMODE EQU   *
1650 073C 08                    PHP   
1651 073D 38                    SEC   
1652 073E 80 02                 BRA   sm2
1653 0740              SETPASCALMODE EQU   *
1654 0740 08                    PHP   
1655 0741 18                    CLC   
1656 0742              SM2      EQU   *
1657 0742 48                    PHA                            ;Preserve A
1658 0743 BD 38 05              LDA   |sermode3,x
1659 0746 29 FB                 AND   #BasicMask--$FF
1660 0748 90 02                 BCC   sm1
1661 074A 09 04                 ORA   #BasicMask
1662 074C              SM1      EQU   *
1663 074C 9D 38 05              STA   |sermode3,x
1664 074F 68                    PLA   
1665 0750 28                    PLP   
1666 0751 60                    RTS   
1667 0752              *
1668 0752              *
1669 0752                       TITLE 'Extended Serial Interface'
1670 0752              *
1671 0752              EXTDISPATCH EQU   *
1672 0752              *
1673 0752              * Preserve three locations in zero page and use these to get to the
1674 0752              *  call command code and parameter count.
1675 0752              *
1676 0752 8B                    PHB   
1677 0753 EB                    XBA   
1678 0754 A5 00                 LDA   zpage
1679 0756 48                    PHA   
1680 0757 A5 01                 LDA   zpage+1
1681 0759 48                    PHA   
1682 075A A5 02                 LDA   zpage+2
1683 075C 48                    PHA   
1684 075D EB                    XBA   
1685 075E              *
1686 075E 85 00                 STA   zpage
1687 0760 86 01                 STX   zpage+1
1688 0762 84 02                 STY   zpage+2
1689 0764              *
1690 0764              * Check for a legal command code
1691 0764              *
1692 0764 A0 01                 LDY   #1
1693 0766 B7 00                 LDA   [zpage],y
1694 0768 C9 19                 CMP   #lastcall+1
1695 076A B0 5D                 BGE   badcall
1696 076C              *
1697 076C              * Check for a valid parameter count... the calls are paired.
1698 076C              *
1699 076C 4A                    LSR   a
1700 076D AA                    TAX   
1701 076E BF E2 07 FF           LDA   >paramct,x
1702 0772 A0 00                 LDY   #0
1703 0774 57 00                 EOR   [zpage],y
1704 0776 D0 13                 BNE   badpcount
1705 0778              *
1706 0778              * Load up the address-1 to vector to.
1707 0778              *
1708 0778 BF 05 08 FF           LDA   >callpage,x
1709 077C 48                    PHA   
1710 077D BF F8 07 FF           LDA   >calltable,x
1711 0781 48                    PHA   
1712 0782              *
1713 0782              * Load up the index registers: X has $C1 or $C2, Y has $3C or $3B.
1714 0782              *
1715 0782 AE F8 07              LDX   |mslot
1716 0785 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
1717 0789 A8                    TAY   
1718 078A 60                    RTS   
1719 078B              *
1720 078B              *
1721 078B              BADPCOUNT EQU   *
1722 078B A9 01                 LDA   #BadPCErr
1723 078D 80 3C                 BRA   ErrExit
1724 078F              *
1725 078F              *
1726 078F              MODEBITS EQU   *
1727 078F              *
1728 078F              * I used to have a beautiful, elegant little routine here that
1729 078F              *  was thirteen bytes smaller than this 'shotgun' routine, which
1730 078F              *  I had to rip out because of the juggling of the screenholes
1731 078F              *  which happened because some old applications broke the rules.
1732 078F              *  (Management said we had to support them anyway.)  You will
1733 078F              *  never be able to experience the simplicity, the ambiance, and
1734 078F              *  general hootspa of the original routine, and Mr. L will never
1735 078F              *  appreciate the sacrifice.
1736 078F              *
1737 078F A0 04                 LDY   #4
1738 0791              *
1739 0791 BD 38 07              LDA   |flags,x
1740 0794 90 02                 BCC   mb1
1741 0796 B7 00                 LDA   [zpage],y
1742 0798              MB1      EQU   *
1743 0798 9D 38 07              STA   |flags,x
1744 079B 97 00                 STA   [zpage],y
1745 079D C8                    INY   
1746 079E              *
1747 079E BD B8 05              LDA   |sermode2,x
1748 07A1 90 02                 BCC   mb2
1749 07A3 B7 00                 LDA   [zpage],y
1750 07A5              MB2      EQU   *
1751 07A5 9D B8 05              STA   |sermode2,x
1752 07A8 97 00                 STA   [zpage],y
1753 07AA C8                    INY   
1754 07AB              *
1755 07AB BD 38 05              LDA   |sermode3,x
1756 07AE 90 02                 BCC   mb3
1757 07B0 B7 00                 LDA   [zpage],y
1758 07B2              MB3      EQU   *
1759 07B2 9D 38 05              STA   |sermode3,x
1760 07B5 97 00                 STA   [zpage],y
1761 07B7 C8                    INY   
1762 07B8              *
1763 07B8 BD B8 04              LDA   |sermode,x
1764 07BB 90 02                 BCC   mb4
1765 07BD B7 00                 LDA   [zpage],y
1766 07BF              MB4      EQU   *
1767 07BF 9D B8 04              STA   |sermode,x
1768 07C2 97 00                 STA   [zpage],y
1769 07C4              *
1770 07C4              OKEXIT   EQU   *
1771 07C4 18                    CLC   
1772 07C5 A9 00                 LDA   #0
1773 07C7 80 03                 BRA   ee1
1774 07C9              *
1775 07C9              BADCALL  EQU   *
1776 07C9 A9 02                 LDA   #BadCallErr
1777 07CB              *
1778 07CB              ERREXIT  EQU   *
1779 07CB 38                    SEC   
1780 07CC              *
1781 07CC              EE1      EQU   *
1782 07CC A0 02                 LDY   #2
1783 07CE 97 00                 STA   [zpage],y
1784 07D0 EB                    XBA                            ;10spd acc preserve
1785 07D1 C8                    INY   
1786 07D2 A9 00                 LDA   #0
1787 07D4 97 00                 STA   [zpage],y
1788 07D6              *
1789 07D6 68                    PLA   
1790 07D7 85 02                 STA   zpage+2
1791 07D9 68                    PLA   
1792 07DA 85 01                 STA   zpage+1
1793 07DC 68                    PLA   
1794 07DD 85 00                 STA   zpage
1795 07DF AB                    PLB   
1796 07E0 EB                    XBA                            ;10spd acc preserve
1797 07E1 6B                    RTL   
1798 07E2              *
1799 07E2              *
1800 07E2              PARAMCT  EQU   *
1801 07E2 03 00 00 03           DC B:3,0,0,3,4,3,3,0
1802 07EA 04 04 02 04           DC B:4,4,2,4,4,0,0,0
1803 07F2 03 03 03 03           DC B:3,3,3,3,4,0
1804 07F8              *
1805 07F8              CALLTABLE EQU   *
1806 07F8 8E C8 C8 67           DC B:MODEBITS-1,BADCALL-1,BADCALL-1,PORT-1
1807 07FC 77 8D 79 C8           DC B:SCC-1,DTR-1,INTERRUPT-1,BADCALL-1
1808 0800 18 11 4C 52           DC B:GETBUFFER-1,SETBUFFER-1,FLUSHQUEUE-1,QUEUESTATUS-1
1809 0804 F9                    DC B:BGPRINT-1
1810 0805              *
1811 0805              CALLPAGE EQU   *
1812 0805 07 07                 DC B:(MODEBITS-1)>>8,(BADCALL-1)>>8
1813 0807 07 0E                 DC B:(BADCALL-1)>>8,(PORT-1)>>8
1814 0809 0E 0E                 DC B:(SCC-1)>>8,(DTR-1)>>8
1815 080B 08 07                 DC B:(INTERRUPT-1)>>8,(BADCALL-1)>>8
1816 080D 08 08                 DC B:(GETBUFFER-1)>>8,(SETBUFFER-1)>>8
1817 080F 08 08                 DC B:(FLUSHQUEUE-1)>>8,(QUEUESTATUS-1)>>8
1818 0811 0D                    DC B:(BGPRINT-1)>>8
1819 0812              *
1820 0812                       EJECT 
1821 0812              *
1822 0812              *
1823 0812              SETBUFFER EQU   *
1824 0812              *
1825 0812              * A flush must occur here to reset the head and tail pointers
1826 0812              *
1827 0812 20 37 08              JSR   Flush                    ;Does a SetQueue
1828 0815 E2 40                 SEP   #%01000000               ;V set means 'set'
1829 0817 80 04                 BRA   gb1
1830 0819              GETBUFFER EQU   *
1831 0819 B8                    CLV                            ;V clear means 'get'
1832 081A 20 1A 0C              JSR   SetQueue
1833 081D              *
1834 081D              * Want to copy over 4+2 bytes of buffer info.
1835 081D              *
1836 081D              GB1      EQU   *
1837 081D BB                    TYX   
1838 081E A0 04                 LDY   #4
1839 0820              GB2      EQU   *
1840 0820 BF D8 1D E1           LDA   >queue,x
1841 0824 50 02                 BVC   gb3
1842 0826 B7 00                 LDA   [zpage],y
1843 0828              GB3      EQU   *
1844 0828 9F D8 1D E1           STA   >queue,x
1845 082C 97 00                 STA   [zpage],y
1846 082E E8                    INX   
1847 082F C8                    INY   
1848 0830 C0 0A                 CPY   #10
1849 0832 90 EC                 BLT   gb2
1850 0834 4C C4 07              JMP   OKExit
1851 0837              *
1852 0837              *
1853 0837              FLUSH    EQU   *
1854 0837              *
1855 0837              * Use X and C to point Y to the queue in question
1856 0837              *
1857 0837 20 1A 0C              JSR   SetQueue
1858 083A              *
1859 083A              * Zero out the head and tail pointers of the queue
1860 083A              *
1861 083A DA                    PHX   
1862 083B BB                    TYX   
1863 083C C2 20                 REP   #%00100000               ;Into 16 bit M
1864 083E                       LONGA ON
1865 083E A9 00 00              LDA   #0
1866 0841 9F DE 1D E1           STA   >QHead,x
1867 0845 9F E0 1D E1           STA   >QTail,x
1868 0849 E2 20                 SEP   #%00100000               ;Into 8 bit M
1869 084B                       LONGA OFF
1870 084B FA                    PLX   
1871 084C 60                    RTS   
1872 084D              *
1873 084D              *
1874 084D              FLUSHQUEUE EQU   *
1875 084D 20 37 08              JSR   Flush
1876 0850 4C C4 07              JMP   OKExit
1877 0853              *
1878 0853              *
1879 0853                       LONGA ON
1880 0853                       LONGI ON
1881 0853              *
1882 0853              QUEUESTATUS EQU   *
1883 0853 B0 05                 BCS   outq                     ;C set means OutQueueStatus
1884 0855 20 9D 0B              JSR   QLength
1885 0858 80 03                 BRA   qs1
1886 085A              OUTQ     EQU   *
1887 085A 20 B3 0B              JSR   QSpace
1888 085D              QS1      EQU   *
1889 085D A0 04 00              LDY   #4
1890 0860 97 00                 STA   [zpage],y
1891 0862              *
1892 0862              * Now give 'em the # of heartbeats since the last char was queued.
1893 0862              *  We just assume that the heartbeat counter has been turned on.
1894 0862              *
1895 0862 C8                    INY   
1896 0863 C8                    INY   
1897 0864 AF DC 00 E1           LDA   >HeartBeat
1898 0868 E0 C2 00              CPX   #$C2
1899 086B 90 01                 BLT   qs2
1900 086D E8                    INX                            ;If port 2, stretch a bit
1901 086E              QS2      EQU   *
1902 086E 38                    SEC   
1903 086F FF D9 14 E1           SBC   >SaveHeartBeat,x
1904 0873 97 00                 STA   [zpage],y
1905 0875 E2 30                 SEP   #%00110000
1906 0877 4C C4 07              JMP   OKExit
1907 087A              *
1908 087A                       LONGA OFF
1909 087A                       LONGI OFF
1910 087A              *
1911 087A              *
1912 087A              INTERRUPT EQU   *
1913 087A 5A                    PHY   
1914 087B DA                    PHX   
1915 087C 08                    PHP   
1916 087D              *
1917 087D A0 08                 LDY   #8
1918 087F A9 03                 LDA   #3
1919 0881 E0 C1                 CPX   #$C1
1920 0883 F0 02                 BEQ   inta
1921 0885 A9 07                 LDA   #7
1922 0887              *
1923 0887              INTA     EQU   *
1924 0887 AA                    TAX   
1925 0888              INTB     EQU   *
1926 0888 28                    PLP   
1927 0889 08                    PHP   
1928 088A B7 00                 LDA   [zpage],y
1929 088C B0 04                 BCS   intc
1930 088E BF C1 15 E1           LDA   >CompVect1,x
1931 0892              INTC     EQU   *
1932 0892 97 00                 STA   [zpage],y
1933 0894 9F C1 15 E1           STA   >CompVect1,x
1934 0898 CA                    DEX   
1935 0899 88                    DEY   
1936 089A              *
1937 089A C0 06                 CPY   #6
1938 089C 10 EA                 BPL   intb
1939 089E              *
1940 089E              * Put in a JML opcode in case it's not there
1941 089E              *
1942 089E A9 5C                 LDA   #$5C
1943 08A0 9F C1 15 E1           STA   >CompVect1,x
1944 08A4              *
1945 08A4 28                    PLP   
1946 08A5 FA                    PLX   
1947 08A6 B0 08                 BCS   setint                   ;Set up the interrupt byte
1948 08A8              *
1949 08A8 7A                    PLY   
1950 08A9 BF E1 14 E1           LDA   >Dishonesty,x
1951 08AD 4C A8 0E              JMP   Spit8bits
1952 08B0              *
1953 08B0              SETINT   EQU   *
1954 08B0 A0 04                 LDY   #4
1955 08B2 B7 00                 LDA   [zpage],y
1956 08B4 9F DD 14 E1           STA   >UserInt,x
1957 08B8 29 EA                 AND   #%11101010
1958 08BA 7A                    PLY   
1959 08BB 48                    PHA   
1960 08BC A9 0F                 LDA   #15
1961 08BE AA                    TAX                            ;For the future write
1962 08BF 20 D0 0D              JSR   ReadSCC
1963 08C2 03 01                 ORA   1,s
1964 08C4 AB                    PLB   
1965 08C5 4C A3 0E              JMP   dtr2
1966 08C8              *
1967 08C8              *
1968 08C8              *
1969 08C8                       TITLE 'Serial Interrupt Handler'
1970 08C8              *
1971 08C8              ********************************************************************
1972 08C8              *                                                                  *
1973 08C8              * Serpint                       SCC Serial Interrupt Handler       *
1974 08C8              *                                                                  *
1975 08C8              *   This routine gains control when the system interrupt dispatch  *
1976 08C8              *  decides that an interrupt which was refused by Appletalk came   *
1977 08C8              *  from the SCC. We first decide which port it's from and return   *
1978 08C8              *  with the carry set if the interrupt status byte is 0, or if our *
1979 08C8              *  buffering mode is not enabled.  Then we look to see if it's an  *
1980 08C8              *  EXSTAT, Tx, or Rx interrupt.  The latter two types are pro-     *
1981 08C8              *  cessed and a character is queued (or dequeued), the interrupt   *
1982 08C8              *  is cleared, the routine is restarted (almost) to guarantee that *
1983 08C8              *  interrupts from multiple sources are appropriately handled. If  *
1984 08C8              *  Each time an interrupt is serviced, the RR0 byte is XORed with  *
1985 08C8              *  the previous value to detect any changes.  When all interrupts  *
1986 08C8              *  have been cleared, the changes are ANDed with a mask from the   *
1987 08C8              *  user, and if any bits are still set, the completion vector is   *
1988 08C8              *  called so that the application is informed of the interrupt.    *
1989 08C8              *                                                                  *
1990 08C8              *    Output:    C <- Cleared if the interrupt was not handled,     *
1991 08C8              *                        set otherwise.                            *
1992 08C8              *                                                                  *
1993 08C8              ********************************************************************
1994 08C8              *
1995 08C8              SERPINT  EQU   *
1996 08C8              *
1997 08C8              * Preserve the state register... system don't do it for me
1998 08C8              *  The DBR is set to $E1 but hardware appears there, too.
1999 08C8              *
2000 08C8 AD 68 C0              LDA   |StateReg
2001 08CB 48                    PHA   
2002 08CC 29 8F                 AND   #%10001111               ;Main memory to access screenholes
2003 08CE 8D 68 C0              STA   |StateReg
2004 08D1              *
2005 08D1              * DBR is set to $E1 when it gets to me...
2006 08D1              *
2007 08D1 9C A2 15              STZ   |Dishonesty+$C1
2008 08D4 9C A3 15              STZ   |Dishonesty+$C2
2009 08D7              *
2010 08D7 8B                    PHB                            ;SETDBR $0000
2011 08D8 F4 00 00              PEA   $0000
2012 08DB AB                    PLB   
2013 08DC AB                    PLB   
2014 08DD              *
2015 08DD              * Determine the channel which has the interrupt
2016 08DD              *
2017 08DD              NEXTINT  EQU   *
2018 08DD A2 C1                 LDX   #$C1
2019 08DF BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
2020 08E3 A8                    TAY   
2021 08E4 A9 03                 LDA   #3
2022 08E6 20 D0 0D              JSR   ReadSCC
2023 08E9 2F 04 01 E1           AND   >serflag                 ;Only ints were supposed to support
2024 08ED C9 08                 CMP   #%00001000               ;Are any of 3..5 set?
2025 08EF B0 21                 BGE   allset1                  ;If so, it's port 1
2026 08F1 E8                    INX   
2027 08F2 88                    DEY   
2028 08F3 C9 00                 CMP   #0
2029 08F5 D0 1E                 BNE   allset                   ;Looks like it's port 2
2030 08F7              *
2031 08F7              * Get our story straight.  If any of the bits in the dishonesty bytes
2032 08F7              *  are set, he asked us to pass control to him.  Call the completion
2033 08F7              *  routine in this case.
2034 08F7              *
2035 08F7              LASTWORD EQU   *
2036 08F7 AF A2 15 E1           LDA   >Dishonesty+$C1          ;Reason to call completion routine
2037 08FB F0 04                 BEQ   si2
2038 08FD 22 C1 15 E1           JSL   >CompVect1
2039 0901              SI2      EQU   *
2040 0901 AF A3 15 E1           LDA   >Dishonesty+$C2          ;Reason to call other comp routine
2041 0905 F0 04                 BEQ   si3
2042 0907 22 C5 15 E1           JSL   >CompVect2
2043 090B              SI3      EQU   *
2044 090B 18                    CLC   
2045 090C              LW1      EQU   *
2046 090C AB                    PLB                            ;Put $E1 back into DBR
2047 090D 68                    PLA   
2048 090E 8D 68 C0              STA   |StateReg                ;Bank reg=$E1- that's okay
2049 0911 6B                    RTL   
2050 0912              *
2051 0912              * It's a channel B interrupt.  Move the channel B interrupt
2052 0912              *  status bits down to where channel A's would be
2053 0912              *
2054 0912              ALLSET1  EQU   *
2055 0912 4A                    LSR   a
2056 0913 4A                    LSR   a
2057 0914 4A                    LSR   a
2058 0915              *
2059 0915              * If buffering isn't on, we don't handle anything
2060 0915              *
2061 0915              ALLSET   EQU   *
2062 0915 EB                    XBA   
2063 0916 BD B8 05              LDA   |sermode2,x
2064 0919 89 40                 BIT   #BfrngMask
2065 091B 38                    SEC                            ;Anticipate no buffering case
2066 091C F0 EE                 BEQ   lw1
2067 091E              *
2068 091E              * Maintain the 'dishonesty' flag. Use XOR to isolate differences
2069 091E              *  in RR0 between now and last time.  Mask and store away.
2070 091E              *
2071 091E B9 FD BF              LDA   SCCCmd,y                 ;Get RR0
2072 0921 48                    PHA                            ;Keep for later
2073 0922 5F DF 14 E1           EOR   >OldRR0,x                ;Resulting bitset means it changed
2074 0926 3F DD 14 E1           AND   >UserInt,x               ;Remember only those they asked for
2075 092A 1F E1 14 E1           ORA   >Dishonesty,x            ;Add to others
2076 092E 9F E1 14 E1           STA   >Dishonesty,x            ;Keep
2077 0932 68                    PLA                            ;Back current RR0
2078 0933 29 FA                 AND   #%11111010               ;Force off rcv and xmit ready...
2079 0935 9F DF 14 E1           STA   >OldRR0,x
2080 0939              *
2081 0939              * Check to see if it is an External/Status interrupt
2082 0939              *
2083 0939 EB                    XBA                            ;Get back the interrupt status
2084 093A 4A                    LSR   a                        ;Is it an Ext/Stat?
2085 093B 90 26                 BCC   mabtx
2086 093D              *
2087 093D              * It is an Ext/Stat interrupt...
2088 093D              *  Don't need zero count interrupts at this point
2089 093D              *
2090 093D A9 0F                 LDA   #15
2091 093F 20 D0 0D              JSR   ReadSCC
2092 0942 29 FD                 AND   #%11111101
2093 0944 DA                    PHX   
2094 0945 A2 0F                 LDX   #15
2095 0947 20 C3 0D              JSR   WriteSCC
2096 094A FA                    PLX   
2097 094B              *
2098 094B              * Change the "no flow" bit if necessary.
2099 094B              *
2100 094B 20 B2 02              JSR   HardCheck                ;Set the noflow bit appropriately
2101 094E              *
2102 094E              * Now clear out the interrupt... currently ignore the fact that
2103 094E              *  a user may have asked to deal with an interrupt from an external/
2104 094E              *  status line that is not handshaked (with buffering on).
2105 094E              *
2106 094E A9 10                 LDA   #%00010000
2107 0950 99 FD BF              STA   SCCCmd,y                 ;Just to speed things up a bit
2108 0953              *
2109 0953              * See if we should start characters flowing out.
2110 0953              *
2111 0953              TXCHECK  EQU   *
2112 0953 BD 38 07              LDA   |flags,x
2113 0956 89 02                 BIT   #WaitXMask
2114 0958 D0 83                 BNE   nextint                  ;If still awaiting XON, never mind
2115 095A              *
2116 095A B9 FD BF              LDA   SCCCmd,y
2117 095D 89 04                 BIT   #%00000100
2118 095F F0 2A                 BEQ   nihitch
2119 0961 80 03                 BRA   cleartxint
2120 0963              *
2121 0963              * Check to see whether it is a transmit interrupt
2122 0963              *
2123 0963              MABTX    EQU   *
2124 0963 4A                    LSR   a                        ;Move Tx bit to carry
2125 0964 90 2D                 BCC   itsrcv                   ;Gotta be a receive interrupt
2126 0966              * 
2127 0966              * It's a transmit interrupt.  Clear it.
2128 0966              *
2129 0966              CLEARTXINT EQU   *
2130 0966 A9 28                 LDA   #%00101000
2131 0968 99 FD BF              STA   SCCCmd,y
2132 096B              *
2133 096B              * If we're in "no flow", there's nothing we can do.  Continue
2134 096B              *  what we can do... just swallow it (and our pride) and continue.
2135 096B              *
2136 096B BD B8 05              LDA   |sermode2,x
2137 096E 89 02                 BIT   #outflomask
2138 0970 D0 19                 BNE   nihitch
2139 0972              *
2140 0972              * If we're doing XON/XOFF handshake and awaiting XOFF, bail out
2141 0972              *
2142 0972 BD 38 07              LDA   |flags,x
2143 0975 89 02                 BIT   #WaitXMask
2144 0977 D0 12                 BNE   nihitch
2145 0979              *
2146 0979              * We're flowing now... pull a char from the queue and shove it
2147 0979              *
2148 0979 38                    SEC                            ;Want to use this channel's outqueue
2149 097A 20 42 0B              JSR   DeQueue                  ;Pull out the next character  
2150 097D B0 0F                 BCS   sendit                   ;If we got a character send it
2151 097F              *
2152 097F              * If we underflow and we're backgroung printing, we are obliged to
2153 097F              *  call the recharge routine.
2154 097F              *
2155 097F BD B8 05              LDA   |sermode2,x
2156 0982 89 01                 BIT   #BRPMask
2157 0984 F0 05                 BEQ   nihitch
2158 0986              *
2159 0986              * Flush the queues, call the recharge routine, and store away the 
2160 0986              *  newly specified length.
2161 0986              *
2162 0986 20 93 0A              JSR   FPlusR
2163 0989 D0 C8                 BNE   txcheck                  ;A virtual transmit interrupt
2164 098B              NIHITCH  EQU   *
2165 098B 4C DD 08              JMP   nextint
2166 098E              SENDIT   EQU   *
2167 098E 99 FF BF              STA   SCCData,y
2168 0991 80 F8                 BRA   nihitch                  ;Back in case there is more
2169 0993              *
2170 0993              * It's a receive interrupt
2171 0993              *
2172 0993              ITSRCV   EQU   *
2173 0993 5A                    PHY   
2174 0994 20 24 03              JSR   GetData                  ;Get the data
2175 0997 7A                    PLY   
2176 0998 90 23                 BCC   readmore                 ;It was eaten... don't queue it
2177 099A              *
2178 099A              * Put the byte into the receiver queue
2179 099A              *
2180 099A 18                    CLC   
2181 099B 20 F8 0A              JSR   Enqueue                  ;Do it
2182 099E              *
2183 099E              * If the buffer overflowed, there's nothing I can do.  Just clear
2184 099E              *  the receiver interrupt and have a nice day.
2185 099E              *
2186 099E B0 1D                 BCS   readmore                 ;Hard buffer overflow
2187 09A0              *
2188 09A0              * Record the time of the enqueing of the character.
2189 09A0              *
2190 09A0 DA                    PHX   
2191 09A1 E0 C2                 CPX   #$C2
2192 09A3 90 01                 BLT   ir1
2193 09A5 E8                    INX   
2194 09A6              IR1      EQU   *
2195 09A6 AF DC 00 E1           LDA   >heartbeat
2196 09AA 9F D9 14 E1           STA   >SaveHeartBeat,x
2197 09AE AF DD 00 E1           LDA   >heartbeat+1
2198 09B2 9F DA 14 E1           STA   >SaveHeartBeat+1,x
2199 09B6 FA                    PLX   
2200 09B7              *
2201 09B7              * If the buffer is within 1/4 bufsize of overflowing, disassert
2202 09B7              *  the handshake, however he said.
2203 09B7              *
2204 09B7 50 04                 BVC   readmore                 ;There was no overflow
2205 09B9 38                    SEC   
2206 09BA 20 2C 0A              JSR   chghs                    ;Flip hs and inflow bit if nec
2207 09BD              *
2208 09BD              * Is there another character to grab?  Grab if so
2209 09BD              *
2210 09BD              READMORE EQU   *
2211 09BD B9 FD BF              LDA   SCCCmd,y
2212 09C0 4A                    LSR   a
2213 09C1 B0 D0                 BCS   itsrcv
2214 09C3 4C 53 09              JMP   txcheck
2215 09C6              *
2216 09C6              *
2217 09C6                       TITLE 'Interrupt Support'
2218 09C6              *
2219 09C6              *
2220 09C6              *********************************************
2221 09C6              *                                           *
2222 09C6              * EnableInt     Enable Buffering Interrupts *
2223 09C6              *                                           *
2224 09C6              *   This sets up Rx, Tx and possibly Exstat *
2225 09C6              *  interrupts in the SCC for the port       *
2226 09C6              *  specified in X so that buffering may     *
2227 09C6              *  occur.                                   *
2228 09C6              *                                           *
2229 09C6              *   Input:    X <- $C1, $C2                 *
2230 09C6              *   Output:   Y <- SCC index ($3C,$3B)      *
2231 09C6              *   Destroys: A,X                           *
2232 09C6              *   Assumes:  DBR <- $00                    *
2233 09C6              *                                           *
2234 09C6              *********************************************
2235 09C6              *
2236 09C6              ENABLEINT:  
2237 09C6              *
2238 09C6              * Do not do anything to the SCC if we're in AppleTalk mode
2239 09C6              *
2240 09C6 BF D5 14 E1           LDA   >ApTalkFlag,x
2241 09CA 10 01                 BPL   ei11
2242 09CC 60                    RTS                            ;Nevermind
2243 09CD              EI11     EQU   *
2244 09CD              *
2245 09CD              * Get the SCC index
2246 09CD              *
2247 09CD BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
2248 09D1 A8                    TAY   
2249 09D2              *
2250 09D2              * Disable interrupts generally while fiddling (I hope Rome isn't burning)
2251 09D2              *
2252 09D2 DA                    PHX   
2253 09D3 A9 02                 LDA   #%00000010
2254 09D5 A2 09                 LDX   #9
2255 09D7 20 C3 0D              JSR   WriteSCC
2256 09DA FA                    PLX   
2257 09DB              *
2258 09DB              * Now set the serial interrupt byte for the system interrupt handler
2259 09DB              *
2260 09DB AF 04 01 E1           LDA   >SERFLAG
2261 09DF E0 C2                 CPX   #$C2
2262 09E1 90 04                 BLT   eia
2263 09E3 09 07                 ORA   #$07
2264 09E5 80 02                 BRA   eia1
2265 09E7              EIA      EQU   *
2266 09E7 09 38                 ORA   #$38
2267 09E9              EIA1     EQU   *
2268 09E9 8F 04 01 E1           STA   >SERFLAG
2269 09ED              *
2270 09ED              * Decide which Ex/Stat interrupts should be enabled
2271 09ED              *
2272 09ED BD B8 05              LDA   |sermode2,x
2273 09F0 89 20                 BIT   #DCDHSMask
2274 09F2 08                    PHP                            ;Keep Z for a minute
2275 09F3 BD 38 07              LDA   |flags,x
2276 09F6 29 04                 AND   #DSRHSMask               ;0 if no DSR handshake
2277 09F8 F0 02                 BEQ   ei1
2278 09FA A9 20                 LDA   #%00100000               ;DSR (CTS) interrupt enabled
2279 09FC              EI1      EQU   *
2280 09FC 28                    PLP                            ;Get back /DCDHS in Z
2281 09FD F0 02                 BEQ   ei2                      ;Z=1 => no DCD handshake
2282 09FF 09 08                 ORA   #%00001000
2283 0A01              *
2284 0A01              * Now write out the Ex/Stat interrupt enables byte
2285 0A01              *
2286 0A01              EI2      EQU   *
2287 0A01 09 02                 ORA   #%00000010               ;ZeroCount ints enforces an interrupt
2288 0A03 A2 0F                 LDX   #15
2289 0A05 20 C3 0D              JSR   WriteSCC
2290 0A08              *
2291 0A08              * Now set up for Rx, Tx, and Ex/Stat interrupts
2292 0A08              *
2293 0A08 A9 13                 LDA   #%00010011
2294 0A0A A2 01                 LDX   #1
2295 0A0C 20 C3 0D              JSR   WriteSCC
2296 0A0F              *
2297 0A0F              * Disable interrupts while we set up the interrupt vector
2298 0A0F              *
2299 0A0F 08                    PHP   
2300 0A10 78                    SEI   
2301 0A11 A9 FF                 LDA   #$FF
2302 0A13 8F 27 00 E1           STA   >SerVect+3
2303 0A17 A9 08                 LDA   #>Serpint
2304 0A19 8F 26 00 E1           STA   >SerVect+2
2305 0A1D A9 C8                 LDA   #<Serpint
2306 0A1F 8F 25 00 E1           STA   >SerVect+1
2307 0A23 28                    PLP   
2308 0A24              *
2309 0A24              * Now enable interrupts and enjoy your stay here in Serialand.
2310 0A24              *
2311 0A24 58                    CLI   
2312 0A25 A9 0A                 LDA   #%00001010
2313 0A27 A2 09                 LDX   #9
2314 0A29 4C C3 0D              JMP   WriteSCC
2315 0A2C              *
2316 0A2C                       EJECT 
2317 0A2C              *********************************************
2318 0A2C              *                                           *
2319 0A2C              * ChgHS       Assert/Disassert Rx Handshake *
2320 0A2C              *                                           *
2321 0A2C              *   Changes the DTR and/or sends XON/XOFF   *
2322 0A2C              *  characters to assert or disassert the    *
2323 0A2C              *  handshake.  Also sets the "in flow" flag *
2324 0A2C              *  to reflect the current handshake state.  *
2325 0A2C              *                                           *
2326 0A2C              *   Input:    X <- $C1, $C2                 *
2327 0A2C              *             C <- 1 means input flow halt  *
2328 0A2C              *             Y <- SCC index ($3C,$3B)      *
2329 0A2C              *   Destroys: A                             *
2330 0A2C              *   Presrvs:  X,Y                           *
2331 0A2C              *   Assumes:  DBR <- $00                    *
2332 0A2C              *                                           *
2333 0A2C              *********************************************
2334 0A2C              *
2335 0A2C              CHGHS    EQU   *
2336 0A2C              *
2337 0A2C              * If we are flowing (inflow=0) and carry set: inflow=1,(DTR=1),(XOFF)
2338 0A2C              *  If we aren't flowing and carry clear: inflow=0,(DTR=0),(XON)
2339 0A2C              *  Otherwise don't do anything.
2340 0A2C              *
2341 0A2C A9 00                 LDA   #0
2342 0A2E 90 02                 BCC   ch2
2343 0A30 A9 04                 LDA   #InFloMask
2344 0A32              CH2      EQU   *
2345 0A32 5D B8 05              EOR   |sermode2,x
2346 0A35 29 04                 AND   #InFloMask
2347 0A37 F0 3D                 BEQ   donothin
2348 0A39              *
2349 0A39              * InFloMask is still in the acc.  Flip it and store
2350 0A39              *
2351 0A39 5D B8 05              EOR   |sermode2,x
2352 0A3C 9D B8 05              STA   |sermode2,x
2353 0A3F              *
2354 0A3F              * If we're doing hardware handshake, flip it.
2355 0A3F              *
2356 0A3F DA                    PHX   
2357 0A40 BD 38 07              LDA   |flags,x
2358 0A43 48                    PHA   
2359 0A44 89 04                 BIT   #DSRHSMask
2360 0A46 F0 10                 BEQ   ch1
2361 0A48              *
2362 0A48 BB                    TYX   
2363 0A49 BF 57 15 E1           LDA   >WR5,x
2364 0A4D 49 80                 EOR   #%10000000
2365 0A4F 9F 57 15 E1           STA   >WR5,x
2366 0A53 A2 05                 LDX   #5
2367 0A55 20 C3 0D              JSR   WriteSCC
2368 0A58              *
2369 0A58              * Now if we're doing XON/XOFF handshake, send either XON or XOFF.
2370 0A58              *
2371 0A58              CH1      EQU   *
2372 0A58 68                    PLA   
2373 0A59 89 20                 BIT   #XMask
2374 0A5B F0 18                 BEQ   ch5                      ;No XON/XOFF
2375 0A5D              *
2376 0A5D 08                    PHP   
2377 0A5E 78                    SEI                            ;Don't go to int handler...
2378 0A5F              CH3      EQU   *
2379 0A5F B9 FD BF              LDA   SCCCmd,y
2380 0A62 89 04                 BIT   #%00000100
2381 0A64 F0 F9                 BEQ   ch3                      ;Wait around til buffer empty
2382 0A66              *
2383 0A66 A9 28                 LDA   #%00101000
2384 0A68 99 FD BF              STA   SCCCmd,y                 ;Clear the newly formed Tx int
2385 0A6B              *
2386 0A6B A9 13                 LDA   #NewXOff                 ;High bit cleared for TenSpeed
2387 0A6D B0 02                 BCS   ch4
2388 0A6F A9 11                 LDA   #NewXOn                  ;High bit cleared for TenSpeed
2389 0A71              CH4      EQU   *
2390 0A71 99 FF BF              STA   SCCData,y                ;Shove it out
2391 0A74 28                    PLP                            ;Reenable interrupts
2392 0A75              *
2393 0A75              CH5      EQU   *
2394 0A75 FA                    PLX                            ;Need $CN for later
2395 0A76              DONOTHIN EQU   *
2396 0A76 60                    RTS   
2397 0A77              *
2398 0A77              *
2399 0A77              *
2400 0A77              RECHARGE EQU   *
2401 0A77              *
2402 0A77              * Calls the callers recharge routine to get more chars in the buffer
2403 0A77              *  Stored address is one bigger than the one that we want on the stack
2404 0A77              *  (from which we'll do an RTL to vector control).
2405 0A77              *
2406 0A77 A0 02                 LDY   #2
2407 0A79 E0 C2                 CPX   #$C2
2408 0A7B BB                    TYX   
2409 0A7C 90 02                 BLT   rch1
2410 0A7E A2 05                 LDX   #5
2411 0A80              RCH1     EQU   *
2412 0A80 18                    CLC   
2413 0A81              RCH2     EQU   *
2414 0A81 BF A4 15 E1           LDA   >rchgadr1,x
2415 0A85 E9 00                 SBC   #0
2416 0A87 48                    PHA   
2417 0A88 CA                    DEX   
2418 0A89 88                    DEY   
2419 0A8A 10 F5                 BPL   rch2
2420 0A8C              *
2421 0A8C              * Unfortunately, they're now on the stack in the wrong order...
2422 0A8C              *
2423 0A8C FA                    PLX   
2424 0A8D 7A                    PLY   
2425 0A8E 68                    PLA   
2426 0A8F DA                    PHX   
2427 0A90 5A                    PHY   
2428 0A91 48                    PHA   
2429 0A92 6B                    RTL   
2430 0A93              *
2431 0A93              *
2432 0A93              * Flush the queues, call the recharge routine, and store away the 
2433 0A93              *  newly specified length.
2434 0A93              *
2435 0A93              FPLUSR   EQU   *
2436 0A93 5A                    PHY   
2437 0A94 DA                    PHX   
2438 0A95              *
2439 0A95 38                    SEC                            ;Output queue
2440 0A96 20 37 08              JSR   Flush
2441 0A99 FA                    PLX   
2442 0A9A DA                    PHX                            ;Resave X
2443 0A9B              *
2444 0A9B              * Call the recharge routine and save away the new data length
2445 0A9B              *
2446 0A9B 5A                    PHY   
2447 0A9C              *
2448 0A9C              * Preserve MSlot across the recharge routine since the app may
2449 0A9C              *  want to make a call to the regular serial code which slams mslot
2450 0A9C              *  to $C1.
2451 0A9C              *
2452 0A9C AF F8 07 00           LDA   >mslot
2453 0AA0 48                    PHA   
2454 0AA1 22 77 0A FF           JSL   >Recharge
2455 0AA5 68                    PLA   
2456 0AA6 8F F8 07 00           STA   >mslot
2457 0AAA              *
2458 0AAA 8A                    TXA   
2459 0AAB FA                    PLX   
2460 0AAC 9F E0 1D E1           STA   >QTail,x
2461 0AB0 98                    TYA   
2462 0AB1 9F E1 1D E1           STA   >QTail+1,x
2463 0AB5 1F E0 1D E1           ORA   >QTail,x
2464 0AB9              *
2465 0AB9 EB                    XBA   
2466 0ABA FA                    PLX   
2467 0ABB 7A                    PLY   
2468 0ABC EB                    XBA                            ;Set zero flag again
2469 0ABD D0 0A                 BNE   fpr1
2470 0ABF              *
2471 0ABF 08                    PHP   
2472 0AC0 BD B8 05              LDA   |sermode2,x
2473 0AC3 29 FE                 AND   #BRPMask--$FF
2474 0AC5 9D B8 05              STA   |sermode2,x
2475 0AC8 28                    PLP   
2476 0AC9              *
2477 0AC9              FPR1     EQU   *
2478 0AC9 60                    RTS   
2479 0ACA              *
2480 0ACA              *
2481 0ACA              * This routine is called by AppleTalk to get a background character
2482 0ACA              *  to print.
2483 0ACA              *
2484 0ACA              ATDEQ    EQU   *
2485 0ACA              *
2486 0ACA              * Figure out what port he wants by looking at Appletalk bit port 1
2487 0ACA              *
2488 0ACA A2 C1                 LDX   #$C1
2489 0ACC BF D5 14 E1           LDA   >ApTalkFlag,x
2490 0AD0 30 01                 BMI   iwsrite
2491 0AD2 E8                    INX                            ;I guess it's port 2... no prob
2492 0AD3              *
2493 0AD3              IWSRITE  EQU   *
2494 0AD3 38                    SEC                            ;It is the output queue we want
2495 0AD4 20 42 0B              JSR   DeQueue                  ;Try to get a character
2496 0AD7 B0 06                 BCS   atbrp1                   ;Got one...give it to 'em
2497 0AD9              *
2498 0AD9 20 93 0A              JSR   FPlusR                   ;Flush, Recharge and endcheck
2499 0ADC D0 EC                 BNE   ATDeQ                    ;Get the first of the next group
2500 0ADE              *
2501 0ADE 18                    CLC                            ;No more background printing
2502 0ADF              ATBRP1   EQU   *
2503 0ADF 6B                    RTL                            ;He JSL'd to us
2504 0AE0              *
2505 0AE0              *
2506 0AE0              INTKILL  EQU   *
2507 0AE0 BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
2508 0AE4 A8                    TAY                            ;We got the port hardware index
2509 0AE5 DA                    PHX   
2510 0AE6 20 B5 0D              JSR   ClearInt                 ;Disable ints globally (this chnl)
2511 0AE9 FA                    PLX   
2512 0AEA B9 FF BF              LDA   |SCCData,y               ;Pull any Rx chars pending
2513 0AED A9 D0                 LDA   #%11010000               ;Clear any Tx ovrn & Exstat ints
2514 0AEF 99 FD BF              STA   |SCCCmd,y
2515 0AF2 A9 28                 LDA   #%00101000               ;Clear any pending Tx interrupt
2516 0AF4 99 FD BF              STA   |SCCCmd,y
2517 0AF7 60                    RTS   
2518 0AF8              *
2519 0AF8              *
2520 0AF8                       TITLE 'Buffering Support'
2521 0AF8                       LONGA ON
2522 0AF8                       LONGI ON
2523 0AF8              *********************************************************************
2524 0AF8              *                                                                   *
2525 0AF8              * Enqueue                  Place a character in the specified queue *
2526 0AF8              *                                                                   *
2527 0AF8              *   This routine takes the character passed and places it in the    *
2528 0AF8              *  specified queue.  There are two overflow conditions, hard and    *
2529 0AF8              *  soft.  Soft overflow indicates that the queue is > 3/4 full,     *
2530 0AF8              *  and a hard overflow indicates that the queue is full and that    *
2531 0AF8              *  the character was not queued.                                    *
2532 0AF8              *                                                                   *
2533 0AF8              *   Input:    A <- character to enqueue                             *
2534 0AF8              *             X <- Port ($C1, $C2)                                  *
2535 0AF8              *             C <- 1=Output Queue, 0=Input Queue                    *
2536 0AF8              *   Output:   A,X,Y  <- preserved                                   *
2537 0AF8              *             V <- 1 char queued but queue is close to overflow     *
2538 0AF8              *             C <- 1 char was not queued due to hard overflow       *
2539 0AF8              *   Assumes:  E <- 0 : Native mode                                  *
2540 0AF8              *                                                                   *
2541 0AF8              *********************************************************************
2542 0AF8              *
2543 0AF8              ENQUEUE  EQU   *
2544 0AF8 DA                    PHX   
2545 0AF9 5A                    PHY   
2546 0AFA 8B                    PHB                            ;Keep around the current DBR
2547 0AFB              *
2548 0AFB              * Check to see if the queue has space to grow
2549 0AFB              *
2550 0AFB 48                    PHA                            ;Twice since we'll be 16 bit on return
2551 0AFC 48                    PHA   
2552 0AFD 20 B3 0B              JSR   QSpace
2553 0B00 D0 04                 BNE   enq2
2554 0B02 68                    PLA                            ;Get the character back
2555 0B03 38                    SEC   
2556 0B04 80 36                 BRA   enq4                     ;Return on overflow
2557 0B06              *
2558 0B06              ENQ2     EQU   *
2559 0B06 FA                    PLX                            ;Keep the character in X
2560 0B07              *
2561 0B07              * Set up the soft overflow flag
2562 0B07              *
2563 0B07 E2 40                 SEP   #%01000000               ;Set the overflow flag
2564 0B09 48                    PHA   
2565 0B0A B9 DC 1D              LDA   |QBLen,y
2566 0B0D 4A                    LSR   a
2567 0B0E 4A                    LSR   a
2568 0B0F C3 01                 CMP   1,s
2569 0B11 68                    PLA   
2570 0B12 B0 01                 BGE   enq3
2571 0B14 B8                    CLV                            ;No overlfow- lots of space left
2572 0B15              ENQ3     EQU   *
2573 0B15              *
2574 0B15              * Disable interrupts to prevent race conditions
2575 0B15              *
2576 0B15 08                    PHP   
2577 0B16 78                    SEI                            ;No interrupts to prevent race conds
2578 0B17              *
2579 0B17 5A                    PHY                            ;Save queue index for later
2580 0B18              *
2581 0B18              * Now swap the queue base pointer into zero page to do an indirect store
2582 0B18              *
2583 0B18 20 84 0B              JSR   SwapQBZP
2584 0B1B              *
2585 0B1B              * Insert the character into the tail of the queue.
2586 0B1B              *
2587 0B1B B9 E0 1D              LDA   QTail,y
2588 0B1E A8                    TAY   
2589 0B1F 8A                    TXA                            ;Get the char to enqueue
2590 0B20 E2 20                 SEP   #%00100000               ;Set 8 bit accumulator
2591 0B22 97 00                 STA   [zpage],y
2592 0B24 C2 20                 REP   #%00100000               ;Back to the future
2593 0B26              *
2594 0B26              * Increment tail pointer and swap back zero page
2595 0B26              *
2596 0B26 C8                    INY                            ;QTail:=QTail+1
2597 0B27 98                    TYA   
2598 0B28 7A                    PLY                            ;Get back the Queue index
2599 0B29 48                    PHA                            ;Save QTail
2600 0B2A 20 84 0B              JSR   SwapQBZP
2601 0B2D 68                    PLA   
2602 0B2E              *
2603 0B2E              * Now, might need to adjust QTail if it passed out of the buffer
2604 0B2E              *
2605 0B2E D9 DC 1D              CMP   QBLen,y
2606 0B31 90 03                 BLT   enq1                     ;If QTail<QBLen, no need to wrap
2607 0B33 A9 00 00              LDA   #0
2608 0B36              ENQ1     EQU   *
2609 0B36 99 E0 1D              STA   qtail,y
2610 0B39              *
2611 0B39 28                    PLP                            ;Restore interrupt mask
2612 0B3A 18                    CLC   
2613 0B3B 8A                    TXA                            ;Replace the char in A
2614 0B3C              ENQ4     EQU   *
2615 0B3C E2 30                 SEP   #%00110000               ;Back to 8 bit land
2616 0B3E AB                    PLB   
2617 0B3F 7A                    PLY   
2618 0B40 FA                    PLX   
2619 0B41 60                    RTS   
2620 0B42              *
2621 0B42                       EJECT 
2622 0B42              *********************************************************************
2623 0B42              *                                                                   *
2624 0B42              * Dequeue             Retrieve a character from the specified queue *
2625 0B42              *                                                                   *
2626 0B42              *   This routine gets a character from a queue and returns it in    *
2627 0B42              *  the low 8 bits of the accumulator.  The carry is returned set on *
2628 0B42              *  underflow.  "Soft" underflow is signaled if the queue is filling *
2629 0B42              *  less than 1/4 of the buffer size.                                *
2630 0B42              *                                                                   *
2631 0B42              *   Input:    X <- Port index ($C1, $C2)                            *
2632 0B42              *             C <- 1=Output Queue, 2=Input Queue                    *
2633 0B42              *   Output:   A <- character                                        *
2634 0B42              *             X,Y  Preserved                                        *
2635 0B42              *             V <- 1 "soft" queue underflow                         *
2636 0B42              *             C <- 0 "hard" queue underflow                         *
2637 0B42              *   Assumes:  E <- 0 : Native mode                                  *
2638 0B42              *                                                                   *
2639 0B42              *********************************************************************
2640 0B42              *
2641 0B42              DEQUEUE  EQU   *
2642 0B42 DA                    PHX   
2643 0B43 5A                    PHY   
2644 0B44 8B                    PHB                            ;Keep around the current DBR
2645 0B45              *
2646 0B45              * Check if there are any characters to retrieve
2647 0B45              *
2648 0B45 20 9D 0B              JSR   QLength
2649 0B48 F0 33                 BEQ   nochars                  ;Branch is queue length = 0
2650 0B4A              *
2651 0B4A              * Set the "soft" underflow appropriately
2652 0B4A              *
2653 0B4A E2 40                 SEP   #%01000000               ;Set V
2654 0B4C 48                    PHA   
2655 0B4D B9 DC 1D              LDA   |QBLen,y
2656 0B50 4A                    LSR   a
2657 0B51 4A                    LSR   a
2658 0B52 C3 01                 CMP   1,s
2659 0B54 68                    PLA   
2660 0B55 B0 01                 BGE   deq2
2661 0B57 B8                    CLV                            ;Carry will be set at exit
2662 0B58              DEQ2     EQU   *
2663 0B58 38                    SEC                            ;We're giving back a char
2664 0B59 08                    PHP   
2665 0B5A 78                    SEI                            ;Disable interrupts to avoid race conds
2666 0B5B              *
2667 0B5B              * Now swap QBase into zero page
2668 0B5B              *
2669 0B5B 20 84 0B              JSR   SwapQBZP
2670 0B5E              *
2671 0B5E              * Remove a character from the head of the queue
2672 0B5E              *
2673 0B5E 5A                    PHY                            ;Save off the queue index
2674 0B5F B9 DE 1D              LDA   QHead,y                  ;Get the queue head index
2675 0B62 A8                    TAY                            ;Move for indirect load
2676 0B63 B7 00                 LDA   [zpage],y                ;Get the byte
2677 0B65 AA                    TAX                            ;And save it in X
2678 0B66              *
2679 0B66              * Move the head pointer
2680 0B66              *
2681 0B66 98                    TYA   
2682 0B67 1A                    INC   a
2683 0B68              *
2684 0B68              * Put back zero page and QBase
2685 0B68              *
2686 0B68 7A                    PLY                            ;Get queue index back
2687 0B69 48                    PHA                            ;Save QHead for a sec
2688 0B6A 20 84 0B              JSR   SwapQBZP
2689 0B6D 68                    PLA   
2690 0B6E              *
2691 0B6E              * Maybe have to adjust QHead
2692 0B6E              *
2693 0B6E D9 DC 1D              CMP   QBLen,y
2694 0B71 90 03                 BLT   deq1
2695 0B73 A9 00 00              LDA   #0
2696 0B76              DEQ1     EQU   *
2697 0B76 99 DE 1D              STA   QHead,y
2698 0B79              *
2699 0B79 28                    PLP                            ;The carry is set here
2700 0B7A 8A                    TXA                            ;Move the char back to A
2701 0B7B 80 01                 BRA   deq3
2702 0B7D              *
2703 0B7D              NOCHARS  EQU   *
2704 0B7D 18                    CLC                            ;Return an underflow
2705 0B7E              DEQ3     EQU   *
2706 0B7E E2 30                 SEP   #%00110000               ;Back to 8 bit M,X
2707 0B80 AB                    PLB   
2708 0B81 7A                    PLY   
2709 0B82 FA                    PLX   
2710 0B83 60                    RTS   
2711 0B84              *
2712 0B84                       EJECT 
2713 0B84              **************************************
2714 0B84              *                                    *
2715 0B84              * SwapQBZP       Exchange QBase & ZP *
2716 0B84              *                                    *
2717 0B84              *  Moves the QBase pointer to zero   *
2718 0B84              * page and preserves zero page in    *
2719 0B84              * QBase.  A is destroyed, assumes    *
2720 0B84              * 16 bit modes; 4 bytes are swapped. *
2721 0B84              *                                    *
2722 0B84              **************************************
2723 0B84              *
2724 0B84              SWAPQBZP EQU   *
2725 0B84 B9 D8 1D              LDA   QBase,y
2726 0B87 48                    PHA   
2727 0B88 A5 00                 LDA   zpage
2728 0B8A 99 D8 1D              STA   QBase,y
2729 0B8D 68                    PLA   
2730 0B8E 85 00                 STA   zpage
2731 0B90              *
2732 0B90 B9 DA 1D              LDA   QBase+2,y
2733 0B93 48                    PHA   
2734 0B94 A5 02                 LDA   zpage+2
2735 0B96 99 DA 1D              STA   QBase+2,y
2736 0B99 68                    PLA   
2737 0B9A 85 02                 STA   zpage+2
2738 0B9C              *
2739 0B9C 60                    RTS   
2740 0B9D              *
2741 0B9D              *
2742 0B9D              **************************************
2743 0B9D              *                                    *
2744 0B9D              * QSpace, QLength   Queue count rtns *
2745 0B9D              *                                    *
2746 0B9D              *  These return a 16 bit value       *
2747 0B9D              * reflecting the amount of space     *
2748 0B9D              * remaining or the amount of chars   *
2749 0B9D              * currently in a queue.  It is       *
2750 0B9D              * passed the queue index in Y.       *
2751 0B9D              *                                    *
2752 0B9D              **************************************
2753 0B9D              *
2754 0B9D              QLENGTH  EQU   *
2755 0B9D                       LONGA OFF
2756 0B9D A9 E1                 LDA   #$E1
2757 0B9F                       LONGA ON
2758 0B9F 48                    PHA   
2759 0BA0 AB                    PLB   
2760 0BA1 20 1A 0C              JSR   SetQueue
2761 0BA4 C2 30                 REP   #%00110000
2762 0BA6 B9 E0 1D              LDA   QTail,y
2763 0BA9 38                    SEC   
2764 0BAA F9 DE 1D              SBC   QHead,y
2765 0BAD B0 03                 BGE   ql3
2766 0BAF 79 DC 1D              ADC   QBLen,y
2767 0BB2              QL3      EQU   *
2768 0BB2 60                    RTS   
2769 0BB3              *
2770 0BB3              *
2771 0BB3              QSPACE   EQU   *
2772 0BB3 20 9D 0B              JSR   QLength                  ;Acc <- chars in queue 
2773 0BB6 38                    SEC   
2774 0BB7 F9 DC 1D              SBC   QBLen,y                  ;Acc <- currentlen-maxlen
2775 0BBA 49 FF FF              EOR   #$FFFF
2776 0BBD 60                    RTS                            ;Acc <- maxlen-currentlen-1
2777 0BBE              *
2778 0BBE                       LONGA OFF
2779 0BBE                       LONGI OFF
2780 0BBE              *
2781 0BBE              **************************************
2782 0BBE              *                                    *
2783 0BBE              * ResetQs   Set buffers to defaults  *
2784 0BBE              *                                    *
2785 0BBE              *  This flushes the queues and       *
2786 0BBE              * sets the buffer base and length    *
2787 0BBE              * addresses.  It asks the memory     *
2788 0BBE              * manager for 4K (both buffers) and  *
2789 0BBE              * if this request is refused it uses *
2790 0BBE              * buffer space reserved in bank $E1. *
2791 0BBE              *                                    *
2792 0BBE              *   Input:    X <- $C1, $C2          *
2793 0BBE              *                                    *
2794 0BBE              **************************************
2795 0BBE              *
2796 0BBE                       LONGA ON
2797 0BBE                       LONGI ON
2798 0BBE              RESETQS  EQU   *
2799 0BBE DA                    PHX   
2800 0BBF 8B                    PHB                            ;SETDBR $E1E1
2801 0BC0 F4 E1 E1              PEA   $E1E1
2802 0BC3 AB                    PLB   
2803 0BC4 AB                    PLB   
2804 0BC5 18                    CLC   
2805 0BC6 20 1A 0C              JSR   SetQueue
2806 0BC9              *
2807 0BC9              * Only do this once after open-apple resets (or powerup).  The firsttime
2808 0BC9              *  byte is smashed to zero on open-apple reset (and powerup).
2809 0BC9              *
2810 0BC9 BD 3D 0F              LDA   |firsttime-$C1,x
2811 0BCC D0 3F                 BNE   rq1
2812 0BCE FE 3D 0F              INC   |firsttime-$C1,x
2813 0BD1              *
2814 0BD1              * Try to get a big buffer from the memory manager.
2815 0BD1              *
2816 0BD1 C2 30                 REP   #%00110000
2817 0BD3 5A                    PHY   
2818 0BD4 20 A1 06              JSR   GetBigBuf
2819 0BD7 7A                    PLY   
2820 0BD8 08                    PHP                            ;C=0 means we got a big buffer
2821 0BD9 90 0E                 BCC   rq2                      ;Skip around the default stuff
2822 0BDB              *
2823 0BDB              * We couldn't get a big buffer for some reason.  Luckily we have
2824 0BDB              *  default buffers (they're kinda small) that he can use.
2825 0BDB              *
2826 0BDB A2 E1 00              LDX   #^E1Buffer1              ;Top part
2827 0BDE A9 00 1E              LDA   #E1Buffer1               ;Low part
2828 0BE1 C0 00 00              CPY   #0                       ;Check port number ($0 or $20)
2829 0BE4 F0 03                 BEQ   rq2                      ;It was port one... use buffer 1
2830 0BE6 A9 00 1F              LDA   #E1Buffer2               ;It was port two...
2831 0BE9              *
2832 0BE9              RQ2      EQU   *
2833 0BE9 99 D8 1D              STA   QBase,y
2834 0BEC 8A                    TXA   
2835 0BED 99 DA 1D              STA   QBase+2,y
2836 0BF0              *
2837 0BF0              * Now get the correct buffer size.  Pull back the result (in carry)
2838 0BF0              *  that we were returned by GetBigBuf.  If clear, buffer size is
2839 0BF0              *  bufsize/2, otherwise it is 128 bytes.
2840 0BF0              *
2841 0BF0 28                    PLP   
2842 0BF1 A9 80 00              LDA   #128
2843 0BF4 B0 03                 BCS   rq3
2844 0BF6 A9 00 08              LDA   #bufsize/2
2845 0BF9              RQ3      EQU   *
2846 0BF9 99 DC 1D              STA   QBLen,y
2847 0BFC 99 E6 1D              STA   QBLen+10,y
2848 0BFF              *
2849 0BFF              * Now make the output buffer base pointer...
2850 0BFF              *
2851 0BFF 18                    CLC   
2852 0C00 79 D8 1D              ADC   QBase,y
2853 0C03 99 E2 1D              STA   QBase+10,y
2854 0C06 90 01                 BCC   rq4                      ;No bank cross
2855 0C08 E8                    INX   
2856 0C09              RQ4      EQU   *
2857 0C09 8A                    TXA   
2858 0C0A 99 E4 1D              STA   QBase+12,y
2859 0C0D              *
2860 0C0D              * Now we've got to clean up and flush the buffers.
2861 0C0D              *
2862 0C0D              RQ1      EQU   *
2863 0C0D E2 30                 SEP   #%00110000
2864 0C0F AB                    PLB   
2865 0C10 FA                    PLX   
2866 0C11              *
2867 0C11 18                    CLC   
2868 0C12 20 37 08              JSR   Flush                    ;Flush input buffer
2869 0C15 38                    SEC   
2870 0C16 20 37 08              JSR   Flush                    ;Flush output buffer
2871 0C19              *
2872 0C19 60                    RTS                            ;Flush leaves us in 8 bit M,X
2873 0C1A              *
2874 0C1A                       LONGA OFF
2875 0C1A                       LONGI OFF
2876 0C1A              *
2877 0C1A              *
2878 0C1A              SETQUEUE EQU   *
2879 0C1A EB                    XBA   
2880 0C1B A9 00                 LDA   #0
2881 0C1D 90 02                 BCC   sq1
2882 0C1F A9 0A                 LDA   #10
2883 0C21              SQ1      EQU   *
2884 0C21 E0 C2                 CPX   #$C2
2885 0C23 90 02                 BLT   sqout
2886 0C25 69 13                 ADC   #19                      ;Carry was set
2887 0C27              SQOUT    EQU   *
2888 0C27 A8                    TAY   
2889 0C28 EB                    XBA   
2890 0C29 60                    RTS   
2891 0C2A              *
2892 0C2A              *
2893 0C2A                       TITLE 'Set Initial Register Values'
2894 0C2A              *
2895 0C2A              *******************************************************************
2896 0C2A              *                                                                 *
2897 0C2A              *  Default                    Set up the serial port defaults     *
2898 0C2A              *                                                                 *
2899 0C2A              *   This routine sets up the local storage of the SCC registers   *
2900 0C2A              *  and other information needed by the driver.                    *
2901 0C2A              *                                                                 *
2902 0C2A              *   Input:   X <- $C1-port 1, $C2-port 2                          *
2903 0C2A              *   Preserves:   X                                                *
2904 0C2A              *                                                                 *
2905 0C2A              *******************************************************************
2906 0C2A              *
2907 0C2A              DEFAULT  EQU   *                        ;X enters as $CN
2908 0C2A              *
2909 0C2A              * Get devno in Y, Init this port like a serial/comm port (preserve X)
2910 0C2A              *
2911 0C2A DA                    PHX   
2912 0C2B BF DE 05 FF           LDA   >FFDEVLBL-$C1,x
2913 0C2F A8                    TAY   
2914 0C30              *
2915 0C30 20 20 0D              JSR   ResetSCC                 ;Set up reg 9
2916 0C33              *
2917 0C33              * If in AppleTalk mode, SCC no touch.
2918 0C33              *
2919 0C33 BF D5 14 E1           LDA   >ApTalkFlag,x
2920 0C37 30 09                 BMI   peter
2921 0C39              *
2922 0C39              * First wait until the Tx is underrun to prevent the inadvertent
2923 0C39              *  "chopping" of a byte that we are currently sending out.
2924 0C39              *
2925 0C39              WAITORCA EQU   *
2926 0C39 A9 00                 LDA   #0
2927 0C3B 20 D0 0D              JSR   ReadSCC
2928 0C3E C9 40                 CMP   #%01000000
2929 0C40 F0 F7                 BEQ   waitorca
2930 0C42              *
2931 0C42              * Arrange for stop bits default
2932 0C42              *
2933 0C42              PETER    EQU   *
2934 0C42 A2 07                 LDX   #DefDForm                ;Load index for stop bit deflt
2935 0C44 20 EF 0C              JSR   GetSysDflt               ;0-1 stop, 1-2 stop
2936 0C47 29 01                 AND   #%00000001               ;0000000S
2937 0C49 38                    SEC   
2938 0C4A 2A                    ROL   a                        ;000000S1
2939 0C4B              *
2940 0C4B              * Now fold in the parity bits default. (Do you like merry-go-rounds?)
2941 0C4B              *
2942 0C4B EB                    XBA                            ;A=XXXXXXXX B=000000S1
2943 0C4C A2 08                 LDX   #DefParity               ;Get the index for the parity default
2944 0C4E 20 EF 0C              JSR   GetSysDflt               ;00-Odd, 01-Even, 10-None
2945 0C51 49 02                 EOR   #%00000010               ;A=000000PQ where P=Parity,Q=Even
2946 0C53 4A                    LSR   a                        ;A=0000000P B=000000S1 C=Q
2947 0C54 EB                    XBA                            ;A=000000S1 B=0000000P C=Q
2948 0C55 2A                    ROL   a                        ;A=00000S1Q B=0000000P C=0
2949 0C56 EB                    XBA                            ;A=0000000P B=00000S1Q C=0
2950 0C57 4A                    LSR   a                        ;A=00000000 B=00000S1Q C=P
2951 0C58 EB                    XBA                            ;A=00000S1Q B=00000000 C=P
2952 0C59 2A                    ROL   a                        ;A=0000S1QP B=00000000 C=0
2953 0C5A BB                    TYX                            ;...I'm kinda dizzy...
2954 0C5B 09 40                 ORA   #%01000000               ;X16 clock mode
2955 0C5D 9F 55 15 E1           STA   >WR4,x                   ;Need to preserve register setting
2956 0C61              *
2957 0C61              * And now with the receive word length...
2958 0C61              *
2959 0C61 A2 07                 LDX   #DefDForm                ;Get index for # of data bits
2960 0C63 20 EF 0C              JSR   GetSysDflt               ;00X-5,01X-6,10X-7,11X-8 bits
2961 0C66 4A                    LSR   a                        ;00-5,01-6,02-7,03-8
2962 0C67 29 03                 AND   #%00000011
2963 0C69 AA                    TAX   
2964 0C6A BF 0B 0D FF           LDA   >DBitMap,x
2965 0C6E BB                    TYX   
2966 0C6F 9F 53 15 E1           STA   >WR3,x
2967 0C73              *
2968 0C73              * Finally set the transmit word length
2969 0C73              *
2970 0C73 4A                    LSR   a                        ;0nn00000
2971 0C74 09 0A                 ORA   #%00001010               ;Make sure DTR is hi and RTS is low
2972 0C76 9F 57 15 E1           STA   >WR5,x
2973 0C7A              *
2974 0C7A              * Deal with the baud rate
2975 0C7A              *
2976 0C7A 20 FF 0C              JSR   FigBaud
2977 0C7D              *
2978 0C7D              * Now set all the registers with these stored values
2979 0C7D              *
2980 0C7D FA                    PLX   
2981 0C7E DA                    PHX   
2982 0C7F 20 30 0D              JSR   InitSerial
2983 0C82              *
2984 0C82              * Now set other non-SCC stuff- start with the default flags byte
2985 0C82              *
2986 0C82 A9 00                 LDA   #0
2987 0C84 A2 0B                 LDX   #DefXONHS
2988 0C86              TL1      EQU   *
2989 0C86 EB                    XBA                            ;B has accumulated SCC bits
2990 0C87 20 EF 0C              JSR   GetSysDflt               ;Get the next default flag
2991 0C8A 4A                    LSR   a                        ;Get the boolean out
2992 0C8B EB                    XBA                            ;A has accumulated SCC bits
2993 0C8C 90 04                 BCC   tl2                      ;Branch if default was false
2994 0C8E 1F 0F 0D FF           ORA   >BitTab,x                ;If bit=1 BitTab positions it for SCC
2995 0C92              TL2      EQU   *
2996 0C92 CA                    DEX   
2997 0C93 10 F1                 BPL   tl1                      ;Back for the next default (5 of 'em)
2998 0C95              *
2999 0C95 7A                    PLY   
3000 0C96 49 08                 EOR   #%00001000               ;Reverse the sense of the LF filter
3001 0C98 99 38 07              STA   |flags,y
3002 0C9B              *
3003 0C9B              * Set the escape character up
3004 0C9B              *
3005 0C9B 29 01                 AND   #%00000001
3006 0C9D D0 02                 BNE   defcom
3007 0C9F A9 09                 LDA   #9
3008 0CA1              DEFCOM   EQU   *
3009 0CA1 99 38 04              STA   |eschar,y
3010 0CA4              *
3011 0CA4              * Set the 2nd mode byte (contains buffering, and DCD handshake)
3012 0CA4              *
3013 0CA4 A2 05                 LDX   #DefBuff
3014 0CA6 20 EF 0C              JSR   GetSysDflt               ;Get boolean buffering default
3015 0CA9 F0 02                 BEQ   tl3                      ;=> It's off, so skip turn on
3016 0CAB A9 40                 LDA   #BfrngMask
3017 0CAD              TL3      EQU   *
3018 0CAD EB                    XBA   
3019 0CAE A2 09                 LDX   #DefDCDHS
3020 0CB0 20 EF 0C              JSR   GetSysDflt               ;Get the DCD handshake default
3021 0CB3 4A                    LSR   a
3022 0CB4 EB                    XBA                            ;Get back A
3023 0CB5 90 02                 BCC   tl4                      ;=> skip turn on if off
3024 0CB7 09 20                 ORA   #DCDHSMask
3025 0CB9              TL4      EQU   *
3026 0CB9 BB                    TYX   
3027 0CBA 9D B8 05              STA   |sermode2,x
3028 0CBD              *
3029 0CBD              * Set up the printer width
3030 0CBD              *
3031 0CBD A2 01                 LDX   #DefLen                  ;Get index for Printer Width
3032 0CBF 20 EF 0C              JSR   GetSysDflt               ;0-unlim,1-40,2-72,3-80,4-132
3033 0CC2 AA                    TAX   
3034 0CC3 BF 1B 0D FF           LDA   >LenTab,x
3035 0CC7 99 38 06              STA   |pwdth,y
3036 0CCA              *
3037 0CCA              * And clear out the port mode byte
3038 0CCA              *
3039 0CCA BB                    TYX   
3040 0CCB 9E B8 04              STZ   |sermode,x
3041 0CCE 9E B8 06              STZ   |col,x                   ;Just like SSC
3042 0CD1 BD 38 05              LDA   |sermode3,x
3043 0CD4 29 04                 AND   #BasicMask
3044 0CD6 9D 38 05              STA   |sermode3,x              ;Clear all but the Basic/Pascal bit
3045 0CD9 A9 00                 LDA   #0
3046 0CDB 9F DD 14 E1           STA   >UserInt,x
3047 0CDF              *
3048 0CDF              * If buffering is enabled, set up the queues and enable interrupts
3049 0CDF              *
3050 0CDF BD B8 05              LDA   |sermode2,x
3051 0CE2 89 40                 BIT   #BfrngMask
3052 0CE4 F0 08                 BEQ   tl5
3053 0CE6              *
3054 0CE6 DA                    PHX   
3055 0CE7 20 BE 0B              JSR   ResetQs
3056 0CEA 20 C6 09              JSR   EnableInt
3057 0CED FA                    PLX   
3058 0CEE              *
3059 0CEE              * And now, we're defaulted.
3060 0CEE              *
3061 0CEE              TL5      EQU   *
3062 0CEE 60                    RTS   
3063 0CEF              *
3064 0CEF              *
3065 0CEF              * Get a default.  Y has which port (table) (lsb=0 means port 1),
3066 0CEF              *  and X is the value within the table.  On output X,Y are preserved
3067 0CEF              *  and A has the value retrieved.
3068 0CEF              *
3069 0CEF              GETSYSDFLT EQU   *
3070 0CEF AD F8 07              LDA   |mslot                   ;Move port index to A
3071 0CF2 4A                    LSR   a                        ;C <- 0 if this is port 1
3072 0CF3 90 05                 BCC   gsd1                     ;=> branch for port 2
3073 0CF5 BF C0 02 E1           LDA   >DefPort1,x              ;Get value for port 1
3074 0CF9 60                    RTS   
3075 0CFA              GSD1     EQU   *
3076 0CFA BF CC 02 E1           LDA   >DefPort2,x              ;Get value for port 2
3077 0CFE              ISOUT    EQU   *
3078 0CFE 60                    RTS   
3079 0CFF              *
3080 0CFF              *
3081 0CFF              FIGBAUD  EQU   *
3082 0CFF A2 06                 LDX   #DefBaud                 ;Get index
3083 0D01 20 EF 0C              JSR   GetSysDflt               ;0000-50,1110-19200
3084 0D04 1A                    INC   a                        ;0001-50,1111-19200
3085 0D05              STOREBAUD EQU   *
3086 0D05 BB                    TYX   
3087 0D06 9F 59 15 E1           STA   >WRCD,x
3088 0D0A 60                    RTS   
3089 0D0B              *
3090 0D0B              *
3091 0D0B              * This maps the number of data bits passed in the default table to
3092 0D0B              *  a value directly storable in register 3 (eventually 5).
3093 0D0B              *
3094 0D0B 01 81 41 C1  DBITMAP  DC B:%00000001,%10000001,%01000001,%11000001
3095 0D0F              *
3096 0D0F              * BitTab contains info to remap bits from Control Panel -> flags byte
3097 0D0F              *  The order is Port Mode, Line Length, Delete LF, Add LF, Echo,
3098 0D0F              *  Buffering, Baud, Format, Parity, DCD, DSR, and XON/XOFF.
3099 0D0F              *
3100 0D0F              BITTAB   EQU   *
3101 0D0F 01 00 08 40           DC B:%00000001,%00000000,%00001000,%01000000
3102 0D13 80 00 00 00           DC B:%10000000,%00000000,%00000000,%00000000
3103 0D17 00 00 04 20           DC B:%00000000,%00000000,DSRHSMASK,%00100000
3104 0D1B              *
3105 0D1B              * LenTab has the different line lengths specified by the defaults
3106 0D1B              *
3107 0D1B 00 28 48 50  LENTAB   DC B:0,40,72,80,132
3108 0D20              *
3109 0D20              *
3110 0D20                       EJECT 
3111 0D20              *
3112 0D20              *******************************************************************
3113 0D20              *                                                                 *
3114 0D20              *  InitSerial, ResetSCC       Serial Port Initialization Routines *
3115 0D20              *                                                                 *
3116 0D20              *   These routines do the SCC register storage whenever initially *
3117 0D20              *  and whenever a recieve or transmit option is altered.  It sets *
3118 0D20              *  up the registers in the order recommended by Zilog.  ISerCold  *
3119 0D20              *  does a port reset before drifting down into ISerWarm.          *
3120 0D20              *                                                                 *
3121 0D20              *   Input:   Y <- $3C-port 1, $3B-port 2                          *
3122 0D20              *            X <- $C1-port 1, $C2-port 2                          *
3123 0D20              *                                                                 *
3124 0D20              *******************************************************************
3125 0D20              *
3126 0D20              RESETSCC EQU   *
3127 0D20              *
3128 0D20              * No touch if in AppleTalk mode
3129 0D20              *
3130 0D20 BF D5 14 E1           LDA   >ApTalkFlag,x
3131 0D24 30 D8                 BMI   isout
3132 0D26              *
3133 0D26 BB                    TYX   
3134 0D27 BF 78 0D FF           LDA   >ResetTabl,x
3135 0D2B A2 09                 LDX   #9
3136 0D2D 4C C3 0D              JMP   WriteSCC                 ;Reset this port
3137 0D30              *
3138 0D30              INITSERIAL:  
3139 0D30              *
3140 0D30              * Don't touch that SCC if in AppleTalk mode
3141 0D30              *
3142 0D30 BF D5 14 E1           LDA   >ApTalkFlag,x
3143 0D34 30 C8                 BMI   isout                    ;Sneak use of default routine's rts
3144 0D36              *
3145 0D36              * Do the stop bits and parity setting
3146 0D36              *
3147 0D36 B9 FD BF              LDA   SCCCmd,y                 ;Try to force register sync
3148 0D39              *
3149 0D39 BB                    TYX   
3150 0D3A BF 55 15 E1           LDA   >WR4,x
3151 0D3E A2 04                 LDX   #4
3152 0D40 20 C3 0D              JSR   WriteSCC
3153 0D43              *
3154 0D43              * Set up the interrupts
3155 0D43              *
3156 0D43 BB                    TYX   
3157 0D44 A9 00                 LDA   #0
3158 0D46 A2 01                 LDX   #1
3159 0D48 20 C3 0D              JSR   WriteSCC
3160 0D4B              *
3161 0D4B              * Do the Receive and Transmit word lengths
3162 0D4B              *
3163 0D4B BB                    TYX   
3164 0D4C BF 53 15 E1           LDA   >WR3,x
3165 0D50 48                    PHA                            ;Keep for later
3166 0D51 29 FE                 AND   #%11111110               ;Don't enable yet
3167 0D53 A2 03                 LDX   #3
3168 0D55 20 C3 0D              JSR   WriteSCC
3169 0D58              *
3170 0D58 BB                    TYX   
3171 0D59 BF 57 15 E1           LDA   >WR5,x
3172 0D5D 48                    PHA                            ;Keep this too
3173 0D5E 29 F7                 AND   #%11110111               ;No enable yet
3174 0D60 A2 05                 LDX   #5
3175 0D62 20 C3 0D              JSR   WriteSCC
3176 0D65              *
3177 0D65              * Set up the clock register
3178 0D65              *
3179 0D65 A9 D2                 LDA   #%11010010               ;ChB: XTAL,RxCBR,TxCBR,RTxCBR
3180 0D67 C0 3C                 CPY   #$3C
3181 0D69 F0 02                 BEQ   df1
3182 0D6B A9 52                 LDA   #%01010010               ;ChB: NOXTAL,RxCBR,TxCBR,RTxCBR
3183 0D6D              DF1      EQU   *
3184 0D6D A2 0B                 LDX   #11
3185 0D6F 20 C3 0D              JSR   WriteSCC
3186 0D72              *
3187 0D72              * Set the baud rate
3188 0D72              *
3189 0D72 BB                    TYX   
3190 0D73 BF 59 15 E1           LDA   >WRCD,x
3191 0D77 29 0F                 AND   #%00001111
3192 0D79 AA                    TAX   
3193 0D7A DA                    PHX                            ;Just a second
3194 0D7B BF B5 0E FF           LDA   >BaudTabL,x
3195 0D7F A2 0C                 LDX   #12
3196 0D81 20 C3 0D              JSR   WriteSCC
3197 0D84 FA                    PLX                            ;Got it back
3198 0D85 BF C5 0E FF           LDA   >BaudTabH,x
3199 0D89 A2 0D                 LDX   #13
3200 0D8B 20 C3 0D              JSR   WriteSCC
3201 0D8E              *
3202 0D8E              * Try setting baud options before enabling BRG
3203 0D8E              *
3204 0D8E A2 0E                 LDX   #14
3205 0D90 A9 00                 LDA   #0
3206 0D92 20 C3 0D              JSR   WriteSCC
3207 0D95              *
3208 0D95              * Enable the baud rate generator
3209 0D95              *
3210 0D95 A2 0E                 LDX   #14
3211 0D97 A9 01                 LDA   #%00000001
3212 0D99 20 C3 0D              JSR   WriteSCC
3213 0D9C              *
3214 0D9C              * Turn on the reciever and transmitter
3215 0D9C              *
3216 0D9C 68                    PLA                            ;Get back the WR5 value
3217 0D9D 09 08                 ORA   #%00001000               ;Flip that bit
3218 0D9F A2 05                 LDX   #5
3219 0DA1 20 C3 0D              JSR   WriteSCC
3220 0DA4 68                    PLA                            ; and now the WR3
3221 0DA5 09 01                 ORA   #%00000001               ;Flip dat bit
3222 0DA7 A2 03                 LDX   #3
3223 0DA9 20 C3 0D              JSR   WriteSCC
3224 0DAC              *
3225 0DAC A9 00                 LDA   #0
3226 0DAE A2 0F                 LDX   #15
3227 0DB0 4C C3 0D              JMP   WriteSCC
3228 0DB3              *
3229 0DB3              *
3230 0DB3              RESETTABL EQU   *-$3B
3231 0DB3 0A                    DC B:%00001010                 ;ChB NV- reset removed
3232 0DB4 0A                    DC B:%00001010                 ;ChA NV- reset removed
3233 0DB5              *
3234 0DB5              *
3235 0DB5              CLEARINT EQU   *
3236 0DB5              *
3237 0DB5              * No touch if in AppleTalk mode
3238 0DB5              *
3239 0DB5 BF D5 14 E1           LDA   >ApTalkFlag,x
3240 0DB9 30 07                 BMI   ciout
3241 0DBB              *
3242 0DBB A9 00                 LDA   #0
3243 0DBD A2 01                 LDX   #1
3244 0DBF 20 C3 0D              JSR   WriteSCC                 ;Disable interrupts this port
3245 0DC2              *
3246 0DC2              CIOUT    EQU   *
3247 0DC2 60                    RTS   
3248 0DC3              *
3249 0DC3              *
3250 0DC3                       TITLE 'SCC Support Routines'
3251 0DC3                                                      ; SEG	$FF
3252 0DC3              *
3253 0DC3              *****************************************************************
3254 0DC3              *                                                               *
3255 0DC3              *  ReadSCC, WriteSCC                                            *
3256 0DC3              *                                                               *
3257 0DC3              *   These routines allow read and the write the SCC command     *
3258 0DC3              *  register channel A or B.                                     *
3259 0DC3              *                                                               *
3260 0DC3              *   Input:    A <- $0..$F register number (read)                *
3261 0DC3              *             A <- value to store (write)                       *
3262 0DC3              *             X <- register to store (write)                    *
3263 0DC3              *             Y <- $3C    channel A                             *
3264 0DC3              *                  $3B    channel B                             *
3265 0DC3              *   Output:   A <- register value (read)                        *
3266 0DC3              *             C <- preserved                                    *
3267 0DC3              *                                                               *
3268 0DC3              *****************************************************************
3269 0DC3              *
3270 0DC3              WRITESCC EQU   *
3271 0DC3 08                    PHP                            ;Preserve interrupt status
3272 0DC4 78                    SEI                            ;Disable interrupts to maintain synch
3273 0DC5 48                    PHA                            ;Save value to write
3274 0DC6 8A                    TXA                            ;Get the register number
3275 0DC7 99 FD BF              STA   SCCCmd,y                 ;Set up
3276 0DCA 68                    PLA                            ;Get back the value
3277 0DCB 99 FD BF              STA   SCCCmd,y                 ;Make it real
3278 0DCE 28                    PLP                            ;Okay if interrupts happen now.
3279 0DCF 60                    RTS   
3280 0DD0              *
3281 0DD0              *
3282 0DD0              READSCC  EQU   *
3283 0DD0 08                    PHP   
3284 0DD1 78                    SEI                            ;No interrupts to maintain SCC synch
3285 0DD2 99 FD BF              STA   SCCCmd,y
3286 0DD5 B9 FD BF              LDA   SCCCmd,y
3287 0DD8 EB                    XBA                            ;NZ should be set per A on exit
3288 0DD9 28                    PLP                            ;Interrupt all you want now
3289 0DDA EB                    XBA   
3290 0DDB 60                    RTS   
3291 0DDC              *
3292 0DDC              *
3293 0DDC                                                      ; SEG	$00
3294 0DDC              *
3295 0DDC              * Potpourii
3296 0DDC              *
3297 0DDC              * This routine is only here because of space constraints...
3298 0DDC              *
3299 0DDC              * Check to see if the receive char has an error.  If so, we want
3300 0DDC              *  to eat it and say there's no char available.  If we're doing
3301 0DDC              *  XON/XOFF and the character IS an XON or XOFF, say no char avail;
3302 0DDC              *  otherwise save the char in the one byte buffer and flag.
3303 0DDC              *
3304 0DDC              * The carry is clear if there is no character available, set ow.
3305 0DDC              *
3306 0DDC              POTPOURRI EQU   *
3307 0DDC              *
3308 0DDC              * If this char has an error, and we're filtering errors, eat the
3309 0DDC              *  character and report no char avail.
3310 0DDC              *
3311 0DDC 20 61 03              JSR   CheckError
3312 0DDF 90 18                 BCC   pperr                    ;This char had an error and was eaten
3313 0DE1              *
3314 0DE1              * If we're not doing XON/XOFF protocol, no need to check the char
3315 0DE1              *
3316 0DE1 BD 38 07              LDA   |flags,x
3317 0DE4 89 20                 BIT   #XMask
3318 0DE6 F0 11                 BEQ   pperr                    ;Carry is still set here
3319 0DE8              *
3320 0DE8 20 24 03              JSR   GetData                  ;Pull the char...
3321 0DEB 90 0C                 BCC   pperr                    ;If it was XON/XOFF, no char avail
3322 0DED              *
3323 0DED              FLAGOBB  EQU   *
3324 0DED              *
3325 0DED              * Store char (in Acc) in the one byte buffer and flag buffer full.
3326 0DED              *
3327 0DED 9F D7 14 E1           STA   >OneByteBuf,x
3328 0DF1              *
3329 0DF1 BD B8 05              LDA   |sermode2,x
3330 0DF4 09 10                 ORA   #ChrBufMask
3331 0DF6 9D B8 05              STA   |sermode2,x
3332 0DF9              *
3333 0DF9              PPERR    EQU   *
3334 0DF9 60                    RTS   
3335 0DFA              *
3336 0DFA              *
3337 0DFA                                                      ; SEG	$FF
3338 0DFA              *
3339 0DFA              *
3340 0DFA              BGPRINT  EQU   *
3341 0DFA 90 03                 BCC   bgpokay
3342 0DFC 4C C9 07              JMP   BadCall
3343 0DFF              *
3344 0DFF              * Disable SCC interrupts
3345 0DFF              *
3346 0DFF              BGPOKAY  EQU   *
3347 0DFF DA                    PHX   
3348 0E00 20 B5 0D              JSR   ClearInt                 ;AppleTalk protected
3349 0E03 FA                    PLX   
3350 0E04              *
3351 0E04              * Force on buffering and background printing bits
3352 0E04              *
3353 0E04 BD B8 05              LDA   |sermode2,x
3354 0E07 09 41                 ORA   #BfrngMask+BRPMask
3355 0E09 9D B8 05              STA   |sermode2,x
3356 0E0C              *
3357 0E0C              * Load up the length of data to be sent
3358 0E0C              *
3359 0E0C 5A                    PHY   
3360 0E0D A0 04                 LDY   #4
3361 0E0F C2 30                 REP   #%00110000
3362 0E11 B7 00                 LDA   [zpage],y
3363 0E13 D0 0E                 BNE   bp1
3364 0E15              *
3365 0E15              * Gave us a data length of zero.  Force off buffering and BP bits.
3366 0E15              *
3367 0E15 E2 30                 SEP   #%00110000
3368 0E17 7A                    PLY   
3369 0E18              *
3370 0E18 BD B8 05              LDA   |sermode2,x
3371 0E1B 29 BE                 AND   #BfrngMask+BRPMask--$FF
3372 0E1D 9D B8 05              STA   |sermode2,x
3373 0E20 4C C4 07              JMP   OKExit
3374 0E23              *
3375 0E23              BP1      EQU   *
3376 0E23              *
3377 0E23              * Store the length of data as the queue tail value
3378 0E23              *
3379 0E23 48                    PHA   
3380 0E24 38                    SEC   
3381 0E25 E2 30                 SEP   #%00110000
3382 0E27 20 1A 0C              JSR   SetQueue
3383 0E2A C2 30                 REP   #%00110000
3384 0E2C 68                    PLA   
3385 0E2D              *
3386 0E2D DA                    PHX   
3387 0E2E BB                    TYX   
3388 0E2F 9F E0 1D E1           STA   >QTail,x
3389 0E33                       LONGA ON
3390 0E33 A9 00 00              LDA   #0
3391 0E36                       LONGA OFF
3392 0E36 9F DE 1D E1           STA   >QHead,x
3393 0E3A FA                    PLX   
3394 0E3B E2 30                 SEP   #%00110000
3395 0E3D DA                    PHX   
3396 0E3E              *
3397 0E3E              * Store the recharge address
3398 0E3E              *
3399 0E3E A0 08                 LDY   #8
3400 0E40 E0 C2                 CPX   #$C2
3401 0E42 A2 02                 LDX   #2
3402 0E44              BP5      EQU   *
3403 0E44 B7 00                 LDA   [zpage],y
3404 0E46 B0 06                 BCS   bp2
3405 0E48 9F A4 15 E1           STA   >RchgAdr1,x
3406 0E4C 80 04                 BRA   bp3
3407 0E4E              BP2      EQU   *
3408 0E4E 9F A7 15 E1           STA   >RchgAdr2,x
3409 0E52              BP3      EQU   *
3410 0E52 88                    DEY   
3411 0E53 CA                    DEX   
3412 0E54 10 EE                 BPL   bp5
3413 0E56              *
3414 0E56              * Start interrupts and exit
3415 0E56              *
3416 0E56              BP4      EQU   *
3417 0E56 FA                    PLX   
3418 0E57 7A                    PLY   
3419 0E58 20 C6 09              JSR   EnableInt                ;AppleTalk protected
3420 0E5B              *
3421 0E5B              * If the AppleTalk bit is set, call the AppleTalk BRP start routine
3422 0E5B              *
3423 0E5B BF D5 14 E1           LDA   >ApTalkFlag,x
3424 0E5F 10 04                 BPL   bp6
3425 0E61 22 32 10 E1           JSL   >ATBRP
3426 0E65              *
3427 0E65              BP6      EQU   *
3428 0E65 4C C4 07              JMP   OKExit
3429 0E68              *
3430 0E68                                                      ; SEG	$00
3431 0E68                       TITLE 'Extended Xface Hardware Calls'
3432 0E68              *
3433 0E68              *
3434 0E68                                                      ; SEG	$FF
3435 0E68              *
3436 0E68              PORT     EQU   *
3437 0E68 B0 0B                 BCS   SetPort
3438 0E6A              *
3439 0E6A A9 03                 LDA   #3
3440 0E6C 20 D0 0D              JSR   ReadSCC
3441 0E6F AA                    TAX   
3442 0E70 B9 FD BF              LDA   SCCCmd,y
3443 0E73 80 35                 BRA   spit16bits
3444 0E75              *
3445 0E75              SETPORT  EQU   *
3446 0E75 4C C9 07              JMP   BadCall
3447 0E78              *
3448 0E78              *
3449 0E78              SCC      EQU   *
3450 0E78 5A                    PHY   
3451 0E79 A0 04                 LDY   #4
3452 0E7B B7 00                 LDA   [zpage],y
3453 0E7D AA                    TAX   
3454 0E7E C8                    INY   
3455 0E7F B7 00                 LDA   [zpage],y
3456 0E81 7A                    PLY   
3457 0E82 B0 1F                 BCS   dtr2
3458 0E84 8A                    TXA   
3459 0E85 20 D0 0D              JSR   ReadSCC
3460 0E88 A0 05                 LDY   #5
3461 0E8A 97 00                 STA   [zpage],y
3462 0E8C 80 24                 BRA   okeh
3463 0E8E              *
3464 0E8E              *
3465 0E8E              DTR      EQU   *
3466 0E8E BB                    TYX   
3467 0E8F BF 57 15 E1           LDA   >WR5,x
3468 0E93 90 13                 BCC   spit8bits
3469 0E95 29 6F                 AND   #%01101111
3470 0E97 5A                    PHY   
3471 0E98 A0 04                 LDY   #4
3472 0E9A 17 00                 ORA   [zpage],y
3473 0E9C 7A                    PLY   
3474 0E9D 9F 57 15 E1           STA   >WR5,x
3475 0EA1 A2 05                 LDX   #5
3476 0EA3              DTR2     EQU   *
3477 0EA3 20 C3 0D              JSR   WriteSCC
3478 0EA6 80 0A                 BRA   okeh
3479 0EA8              *
3480 0EA8              *
3481 0EA8              SPIT8BITS EQU   *
3482 0EA8 A2 00                 LDX   #0
3483 0EAA              SPIT16BITS EQU   *
3484 0EAA A0 04                 LDY   #4
3485 0EAC 97 00                 STA   [zpage],y
3486 0EAE C8                    INY   
3487 0EAF 8A                    TXA   
3488 0EB0 97 00                 STA   [zpage],y
3489 0EB2              OKEH     EQU   *
3490 0EB2 4C C4 07              JMP   OKExit
3491 0EB5              *
3492 0EB5              *
3493 0EB5              *
3494 0EB5                                                      ; SEG	$00
3495 0EB5              *
3496 0EB5              *
3497 0EB5                                                      ; SEG	$FF
3498 0EB5              *
3499 0EB5              *
3500 0EB5              BAUDTABL EQU   *
3501 0EB5 00 FE FE 15           DC B:0,BD50,BD75,BD109,BD134,BD150,BD300
3502 0EBC BE 5E 3E 2E           DC B:BD600,BD1200,BD1800,BD2400,BD3600
3503 0EC1 16 0E 0A 04           DC B:BD4800,BD7200,BD9600,BD19200
3504 0EC5              *
3505 0EC5              BAUDTABH EQU   *
3506 0EC5 00 08 05 04           DC B:0,BD50>>8,BD75>>8,BD109>>8,BD134>>8,BD150>>8,BD300>>8
3507 0ECC 00 00 00 00           DC B:BD600>>8,BD1200>>8,BD1800>>8,BD2400>>8,BD3600>>8
3508 0ED1 00 00 00 00           DC B:BD4800>>8,BD7200>>8,BD9600>>8,BD19200>>8
3509 0ED5              *
3510 0ED5                                                      ; SEG	$00
3511 0ED5              *
3512 0ED5                                                      ; SEG	$FF
3513 0ED5              *
3514 0ED5              NEWBASVEC:  
3515 0ED5 08                    PHP   
3516 0ED6 20 F9 0E              JSR   which
3517 0ED9 B0 05                 BCS   bpat
3518 0EDB 28                    PLP   
3519 0EDC 5C 0C 02 E1           JMP   >SerBasPatch
3520 0EE0 28           BPAT     PLP   
3521 0EE1 5C 04 10 E1           JMP   >ASBas
3522 0EE5              *
3523 0EE5              *
3524 0EE5              NEWPASVEC:  
3525 0EE5 08                    PHP   
3526 0EE6 20 F9 0E              JSR   which
3527 0EE9 B0 05                 BCS   ppat
3528 0EEB 28                    PLP   
3529 0EEC 5C 10 02 E1           JMP   >SerPasPatch
3530 0EF0 28           PPAT     PLP   
3531 0EF1 5C 08 10 E1           JMP   >ASPas
3532 0EF5              *
3533 0EF5              *
3534 0EF5              NEWEXTVEC:  
3535 0EF5              ; The code that called ASEXT has been removed
3536 0EF5              ;  since it's never been used, and would be
3537 0EF5              ;  slightly less than trivial to support.  No one
3538 0EF5              ;  should be making calls to the extended interface
3539 0EF5              ;  when the port is in AppleTalk mode.
3540 0EF5              ;
3541 0EF5              ;php
3542 0EF5              ;jsr which
3543 0EF5              ;bcs epat
3544 0EF5              ;plp
3545 0EF5 5C 14 02 E1           JMP   >SerExtPatch
3546 0EF9              ;epat plp
3547 0EF9              ;jmp =ASExt
3548 0EF9              *
3549 0EF9              *
3550 0EF9              WHICH    EQU   *
3551 0EF9 48                    PHA   
3552 0EFA DA                    PHX   
3553 0EFB 8A                    TXA   
3554 0EFC 6A                    ROR   a
3555 0EFD A2 00                 LDX   #$00
3556 0EFF B0 02                 BCS   npovr
3557 0F01 A2 0C                 LDX   #$0C
3558 0F03              NPOVR    EQU   *
3559 0F03 BF C0 02 E1           LDA   >DefPort1,x
3560 0F07 C9 02                 CMP   #$02
3561 0F09 FA                    PLX                            ;Got back CN
3562 0F0A 90 06                 BCC   npnas                    ;If serial, skip AppleShare flagging
3563 0F0C A9 80                 LDA   #$80                     ;This is the AS flag value
3564 0F0E 9F D5 14 E1           STA   >ApTalkFlag,x
3565 0F12              NPNAS    EQU   *
3566 0F12 68                    PLA   
3567 0F13 60                    RTS   
3568 0F14              *
3569 0F14              *
